package software.amazon.awscdk.services.scheduler;

/**
 * The text or well-formed JSON input passed to the target of the schedule.
 * <p>
 * Tokens and ContextAttribute may be used in the input.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sns.*;
 * Topic topic = new Topic(this, "Topic");
 * Map&lt;String, String&gt; payload = Map.of(
 *         "message", "Hello scheduler!");
 * SnsPublish target = SnsPublish.Builder.create(topic)
 *         .input(ScheduleTargetInput.fromObject(payload))
 *         .build();
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.hours(1)))
 *         .target(target)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.546Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.ScheduleTargetInput")
public abstract class ScheduleTargetInput extends software.amazon.jsii.JsiiObject {

    protected ScheduleTargetInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduleTargetInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ScheduleTargetInput() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Pass a JSON object to the target.
     * <p>
     * The object will be transformed into a well-formed JSON string in the final template.
     * <p>
     * @param obj object to use to convert to JSON to use as input for the target. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetInput fromObject(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class), new Object[] { obj });
    }

    /**
     * Pass simple text to the target.
     * <p>
     * For passing complex values like JSON object to a target use method
     * <code>ScheduleTargetInput.fromObject()</code> instead.
     * <p>
     * @param text Text to use as the input for the target. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetInput fromText(final @org.jetbrains.annotations.NotNull java.lang.String text) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class, "fromText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class), new Object[] { java.util.Objects.requireNonNull(text, "text is required") });
    }

    /**
     * Return the input properties for this input object.
     * <p>
     * @param schedule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule schedule);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.scheduler.ScheduleTargetInput {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Return the input properties for this input object.
         * <p>
         * @param schedule This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule schedule) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(schedule, "schedule is required") });
        }
    }
}
