package software.amazon.awscdk.services.secretsmanager;

/**
 * A rotation schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Function function_;
 * HostedRotation hostedRotation;
 * Secret secret;
 * RotationSchedule rotationSchedule = RotationSchedule.Builder.create(this, "MyRotationSchedule")
 *         .secret(secret)
 *         // the properties below are optional
 *         .automaticallyAfter(Duration.minutes(30))
 *         .hostedRotation(hostedRotation)
 *         .rotateImmediatelyOnUpdate(false)
 *         .rotationLambda(function_)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.RotationSchedule")
public class RotationSchedule extends software.amazon.awscdk.Resource {

    protected RotationSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RotationSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.RotationSchedule.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RotationSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.RotationSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.RotationSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.RotationScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.RotationScheduleProps.Builder();
        }

        /**
         * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * <p>
         * The minimum value is 4 hours.
         * The maximum value is 1000 days.
         * <p>
         * A value of zero (<code>Duration.days(0)</code>) will not create RotationRules.
         * <p>
         * Default: Duration.days(30)
         * <p>
         * @return {@code this}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(final software.amazon.awscdk.Duration automaticallyAfter) {
            this.props.automaticallyAfter(automaticallyAfter);
            return this;
        }

        /**
         * Hosted rotation.
         * <p>
         * Default: - either `rotationLambda` or `hostedRotation` must be specified
         * <p>
         * @return {@code this}
         * @param hostedRotation Hosted rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotation(final software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation) {
            this.props.hostedRotation(hostedRotation);
            return this;
        }

        /**
         * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(final java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.props.rotateImmediatelyOnUpdate(rotateImmediatelyOnUpdate);
            return this;
        }

        /**
         * A Lambda function that can rotate the secret.
         * <p>
         * Default: - either `rotationLambda` or `hostedRotation` must be specified
         * <p>
         * @return {@code this}
         * @param rotationLambda A Lambda function that can rotate the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambda(final software.amazon.awscdk.services.lambda.IFunction rotationLambda) {
            this.props.rotationLambda(rotationLambda);
            return this;
        }

        /**
         * The secret to rotate.
         * <p>
         * If hosted rotation is used, this must be a JSON string with the following format:
         * <p>
         * <blockquote><pre>
         * {
         *   "engine": &lt;required: database engine&gt;,
         *   "host": &lt;required: instance host name&gt;,
         *   "username": &lt;required: username&gt;,
         *   "password": &lt;required: password&gt;,
         *   "dbname": &lt;optional: database name&gt;,
         *   "port": &lt;optional: if not specified, default port will be used&gt;,
         *   "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
         * }
         * </pre></blockquote>
         * <p>
         * This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
         * or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
         * <p>
         * @return {@code this}
         * @param secret The secret to rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.RotationSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.RotationSchedule build() {
            return new software.amazon.awscdk.services.secretsmanager.RotationSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
