package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnOrganizationConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnOrganizationConfigurationProps cfnOrganizationConfigurationProps = CfnOrganizationConfigurationProps.builder()
 *         .autoEnable(false)
 *         // the properties below are optional
 *         .autoEnableStandards("autoEnableStandards")
 *         .configurationType("configurationType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnOrganizationConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnOrganizationConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOrganizationConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically enable Security Hub in new member accounts when they join the organization.
     * <p>
     * If set to <code>true</code> , then Security Hub is automatically enabled in new accounts. If set to <code>false</code> , then Security Hub isn't enabled in new accounts automatically. The default value is <code>false</code> .
     * <p>
     * If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code> , then this field is set to <code>false</code> and can't be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which Security Hub is enabled and associate the policy with new organization accounts.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-autoenable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-autoenable</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAutoEnable();

    /**
     * Whether to automatically enable Security Hub <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default standards</a> in new member accounts when they join the organization.
     * <p>
     * The default value of this parameter is equal to <code>DEFAULT</code> .
     * <p>
     * If equal to <code>DEFAULT</code> , then Security Hub default standards are automatically enabled for new member accounts. If equal to <code>NONE</code> , then default standards are not automatically enabled for new member accounts.
     * <p>
     * If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code> , then this field is set to <code>NONE</code> and can't be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which specific security standards are enabled and associate the policy with new organization accounts.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-autoenablestandards">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-autoenablestandards</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoEnableStandards() {
        return null;
    }

    /**
     * Indicates whether the organization uses local or central configuration.
     * <p>
     * If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code> . This automatically enables Security Hub and default security standards in new organization accounts. These new account settings must be set separately in each AWS Region , and settings may be different in each Region.
     * <p>
     * If you use central configuration, the delegated administrator can create configuration policies. Configuration policies can be used to configure Security Hub, security standards, and security controls in multiple accounts and Regions. If you want new organization accounts to use a specific configuration, you can create a configuration policy and associate it with the root or specific organizational units (OUs). New accounts will inherit the policy from the root or their assigned OU.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-configurationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-organizationconfiguration.html#cfn-securityhub-organizationconfiguration-configurationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOrganizationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOrganizationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOrganizationConfigurationProps> {
        java.lang.Object autoEnable;
        java.lang.String autoEnableStandards;
        java.lang.String configurationType;

        /**
         * Sets the value of {@link CfnOrganizationConfigurationProps#getAutoEnable}
         * @param autoEnable Whether to automatically enable Security Hub in new member accounts when they join the organization. This parameter is required.
         *                   If set to <code>true</code> , then Security Hub is automatically enabled in new accounts. If set to <code>false</code> , then Security Hub isn't enabled in new accounts automatically. The default value is <code>false</code> .
         *                   <p>
         *                   If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code> , then this field is set to <code>false</code> and can't be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which Security Hub is enabled and associate the policy with new organization accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnable(java.lang.Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConfigurationProps#getAutoEnable}
         * @param autoEnable Whether to automatically enable Security Hub in new member accounts when they join the organization. This parameter is required.
         *                   If set to <code>true</code> , then Security Hub is automatically enabled in new accounts. If set to <code>false</code> , then Security Hub isn't enabled in new accounts automatically. The default value is <code>false</code> .
         *                   <p>
         *                   If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code> , then this field is set to <code>false</code> and can't be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which Security Hub is enabled and associate the policy with new organization accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnable(software.amazon.awscdk.IResolvable autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConfigurationProps#getAutoEnableStandards}
         * @param autoEnableStandards Whether to automatically enable Security Hub <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default standards</a> in new member accounts when they join the organization.
         *                            The default value of this parameter is equal to <code>DEFAULT</code> .
         *                            <p>
         *                            If equal to <code>DEFAULT</code> , then Security Hub default standards are automatically enabled for new member accounts. If equal to <code>NONE</code> , then default standards are not automatically enabled for new member accounts.
         *                            <p>
         *                            If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code> , then this field is set to <code>NONE</code> and can't be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which specific security standards are enabled and associate the policy with new organization accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableStandards(java.lang.String autoEnableStandards) {
            this.autoEnableStandards = autoEnableStandards;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConfigurationProps#getConfigurationType}
         * @param configurationType Indicates whether the organization uses local or central configuration.
         *                          If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code> . This automatically enables Security Hub and default security standards in new organization accounts. These new account settings must be set separately in each AWS Region , and settings may be different in each Region.
         *                          <p>
         *                          If you use central configuration, the delegated administrator can create configuration policies. Configuration policies can be used to configure Security Hub, security standards, and security controls in multiple accounts and Regions. If you want new organization accounts to use a specific configuration, you can create a configuration policy and associate it with the root or specific organizational units (OUs). New accounts will inherit the policy from the root or their assigned OU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationType(java.lang.String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOrganizationConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOrganizationConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOrganizationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOrganizationConfigurationProps {
        private final java.lang.Object autoEnable;
        private final java.lang.String autoEnableStandards;
        private final java.lang.String configurationType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoEnable = software.amazon.jsii.Kernel.get(this, "autoEnable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoEnableStandards = software.amazon.jsii.Kernel.get(this, "autoEnableStandards", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationType = software.amazon.jsii.Kernel.get(this, "configurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoEnable = java.util.Objects.requireNonNull(builder.autoEnable, "autoEnable is required");
            this.autoEnableStandards = builder.autoEnableStandards;
            this.configurationType = builder.configurationType;
        }

        @Override
        public final java.lang.Object getAutoEnable() {
            return this.autoEnable;
        }

        @Override
        public final java.lang.String getAutoEnableStandards() {
            return this.autoEnableStandards;
        }

        @Override
        public final java.lang.String getConfigurationType() {
            return this.configurationType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoEnable", om.valueToTree(this.getAutoEnable()));
            if (this.getAutoEnableStandards() != null) {
                data.set("autoEnableStandards", om.valueToTree(this.getAutoEnableStandards()));
            }
            if (this.getConfigurationType() != null) {
                data.set("configurationType", om.valueToTree(this.getConfigurationType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnOrganizationConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOrganizationConfigurationProps.Jsii$Proxy that = (CfnOrganizationConfigurationProps.Jsii$Proxy) o;

            if (!autoEnable.equals(that.autoEnable)) return false;
            if (this.autoEnableStandards != null ? !this.autoEnableStandards.equals(that.autoEnableStandards) : that.autoEnableStandards != null) return false;
            return this.configurationType != null ? this.configurationType.equals(that.configurationType) : that.configurationType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoEnable.hashCode();
            result = 31 * result + (this.autoEnableStandards != null ? this.autoEnableStandards.hashCode() : 0);
            result = 31 * result + (this.configurationType != null ? this.configurationType.hashCode() : 0);
            return result;
        }
    }
}
