package software.amazon.awscdk.services.securitylake;

/**
 * Properties for defining a <code>CfnSubscriber</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * CfnSubscriberProps cfnSubscriberProps = CfnSubscriberProps.builder()
 *         .accessTypes(List.of("accessTypes"))
 *         .dataLakeArn("dataLakeArn")
 *         .sources(List.of(SourceProperty.builder()
 *                 .awsLogSource(AwsLogSourceProperty.builder()
 *                         .sourceName("sourceName")
 *                         .sourceVersion("sourceVersion")
 *                         .build())
 *                 .customLogSource(CustomLogSourceProperty.builder()
 *                         .sourceName("sourceName")
 *                         .sourceVersion("sourceVersion")
 *                         .build())
 *                 .build()))
 *         .subscriberIdentity(SubscriberIdentityProperty.builder()
 *                 .externalId("externalId")
 *                 .principal("principal")
 *                 .build())
 *         .subscriberName("subscriberName")
 *         // the properties below are optional
 *         .subscriberDescription("subscriberDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnSubscriberProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriberProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriberProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * You can choose to notify subscribers of new objects with an Amazon Simple Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint provided by the subscriber.
     * <p>
     * Subscribers can consume data by directly querying AWS Lake Formation tables in your Amazon S3 bucket through services like Amazon Athena. This subscription type is defined as <code>LAKEFORMATION</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-accesstypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-accesstypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccessTypes();

    /**
     * The Amazon Resource Name (ARN) used to create the data lake.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-datalakearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-datalakearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataLakeArn();

    /**
     * Amazon Security Lake supports log and event collection for natively supported AWS services .
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/source-management.html">Amazon Security Lake User Guide</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securitylake.CfnSubscriber.SourceProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-sources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSources();

    /**
     * The AWS identity used to access your data.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securitylake.CfnSubscriber.SubscriberIdentityProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscriberidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscriberidentity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubscriberIdentity();

    /**
     * The name of your Amazon Security Lake subscriber account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscribername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscribername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriberName();

    /**
     * The subscriber descriptions for a subscriber account.
     * <p>
     * The description for a subscriber includes <code>subscriberName</code> , <code>accountID</code> , <code>externalID</code> , and <code>subscriberId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscriberdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-subscriberdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubscriberDescription() {
        return null;
    }

    /**
     * An array of objects, one for each tag to associate with the subscriber.
     * <p>
     * For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscriber.html#cfn-securitylake-subscriber-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubscriberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriberProps> {
        java.util.List<java.lang.String> accessTypes;
        java.lang.String dataLakeArn;
        java.lang.Object sources;
        java.lang.Object subscriberIdentity;
        java.lang.String subscriberName;
        java.lang.String subscriberDescription;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSubscriberProps#getAccessTypes}
         * @param accessTypes You can choose to notify subscribers of new objects with an Amazon Simple Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint provided by the subscriber. This parameter is required.
         *                    Subscribers can consume data by directly querying AWS Lake Formation tables in your Amazon S3 bucket through services like Amazon Athena. This subscription type is defined as <code>LAKEFORMATION</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessTypes(java.util.List<java.lang.String> accessTypes) {
            this.accessTypes = accessTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getDataLakeArn}
         * @param dataLakeArn The Amazon Resource Name (ARN) used to create the data lake. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLakeArn(java.lang.String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSources}
         * @param sources Amazon Security Lake supports log and event collection for natively supported AWS services . This parameter is required.
         *                For more information, see the <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/source-management.html">Amazon Security Lake User Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(software.amazon.awscdk.IResolvable sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSources}
         * @param sources Amazon Security Lake supports log and event collection for natively supported AWS services . This parameter is required.
         *                For more information, see the <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/source-management.html">Amazon Security Lake User Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(java.util.List<? extends java.lang.Object> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSubscriberIdentity}
         * @param subscriberIdentity The AWS identity used to access your data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberIdentity(software.amazon.awscdk.IResolvable subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSubscriberIdentity}
         * @param subscriberIdentity The AWS identity used to access your data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberIdentity(software.amazon.awscdk.services.securitylake.CfnSubscriber.SubscriberIdentityProperty subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSubscriberName}
         * @param subscriberName The name of your Amazon Security Lake subscriber account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberName(java.lang.String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getSubscriberDescription}
         * @param subscriberDescription The subscriber descriptions for a subscriber account.
         *                              The description for a subscriber includes <code>subscriberName</code> , <code>accountID</code> , <code>externalID</code> , and <code>subscriberId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberDescription(java.lang.String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberProps#getTags}
         * @param tags An array of objects, one for each tag to associate with the subscriber.
         *             For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriberProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriberProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriberProps {
        private final java.util.List<java.lang.String> accessTypes;
        private final java.lang.String dataLakeArn;
        private final java.lang.Object sources;
        private final java.lang.Object subscriberIdentity;
        private final java.lang.String subscriberName;
        private final java.lang.String subscriberDescription;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessTypes = software.amazon.jsii.Kernel.get(this, "accessTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dataLakeArn = software.amazon.jsii.Kernel.get(this, "dataLakeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscriberIdentity = software.amazon.jsii.Kernel.get(this, "subscriberIdentity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscriberName = software.amazon.jsii.Kernel.get(this, "subscriberName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriberDescription = software.amazon.jsii.Kernel.get(this, "subscriberDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessTypes = java.util.Objects.requireNonNull(builder.accessTypes, "accessTypes is required");
            this.dataLakeArn = java.util.Objects.requireNonNull(builder.dataLakeArn, "dataLakeArn is required");
            this.sources = java.util.Objects.requireNonNull(builder.sources, "sources is required");
            this.subscriberIdentity = java.util.Objects.requireNonNull(builder.subscriberIdentity, "subscriberIdentity is required");
            this.subscriberName = java.util.Objects.requireNonNull(builder.subscriberName, "subscriberName is required");
            this.subscriberDescription = builder.subscriberDescription;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getAccessTypes() {
            return this.accessTypes;
        }

        @Override
        public final java.lang.String getDataLakeArn() {
            return this.dataLakeArn;
        }

        @Override
        public final java.lang.Object getSources() {
            return this.sources;
        }

        @Override
        public final java.lang.Object getSubscriberIdentity() {
            return this.subscriberIdentity;
        }

        @Override
        public final java.lang.String getSubscriberName() {
            return this.subscriberName;
        }

        @Override
        public final java.lang.String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessTypes", om.valueToTree(this.getAccessTypes()));
            data.set("dataLakeArn", om.valueToTree(this.getDataLakeArn()));
            data.set("sources", om.valueToTree(this.getSources()));
            data.set("subscriberIdentity", om.valueToTree(this.getSubscriberIdentity()));
            data.set("subscriberName", om.valueToTree(this.getSubscriberName()));
            if (this.getSubscriberDescription() != null) {
                data.set("subscriberDescription", om.valueToTree(this.getSubscriberDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnSubscriberProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriberProps.Jsii$Proxy that = (CfnSubscriberProps.Jsii$Proxy) o;

            if (!accessTypes.equals(that.accessTypes)) return false;
            if (!dataLakeArn.equals(that.dataLakeArn)) return false;
            if (!sources.equals(that.sources)) return false;
            if (!subscriberIdentity.equals(that.subscriberIdentity)) return false;
            if (!subscriberName.equals(that.subscriberName)) return false;
            if (this.subscriberDescription != null ? !this.subscriberDescription.equals(that.subscriberDescription) : that.subscriberDescription != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessTypes.hashCode();
            result = 31 * result + (this.dataLakeArn.hashCode());
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.subscriberIdentity.hashCode());
            result = 31 * result + (this.subscriberName.hashCode());
            result = 31 * result + (this.subscriberDescription != null ? this.subscriberDescription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
