package software.amazon.awscdk.services.servicecatalog;

/**
 * Product stack props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.Bucket;
 * public class LambdaProduct extends ProductStack {
 *     public LambdaProduct(Construct scope, String id, ProductStackProps props) {
 *         super(scope, id, props);
 *         Function.Builder.create(this, "LambdaProduct")
 *                 .runtime(Runtime.PYTHON_3_9)
 *                 .code(Code.fromAsset("./assets"))
 *                 .handler("index.handler")
 *                 .build();
 *     }
 * }
 * Bucket userDefinedBucket = Bucket.Builder.create(this, "UserDefinedBucket")
 *         .bucketName("amzn-s3-demo-bucket")
 *         .build();
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "Product")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(CloudFormationProductVersion.builder()
 *                 .productVersionName("v1")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromProductStack(LambdaProduct.Builder.create(this, "LambdaFunctionProduct")
 *                         .assetBucket(userDefinedBucket)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.831Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.ProductStackProps")
@software.amazon.jsii.Jsii.Proxy(ProductStackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProductStackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Include runtime versioning information in this Stack.
     * <p>
     * Default: - `analyticsReporting` setting of containing `App`, or value of
     * 'aws:cdk:version-reporting' context key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAnalyticsReporting() {
        return null;
    }

    /**
     * A Bucket can be passed to store assets, enabling ProductStack Asset support.
     * <p>
     * Default: - No Bucket provided and Assets will not be supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getAssetBucket() {
        return null;
    }

    /**
     * A description of the stack.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
     * <p>
     * If you are deploying large files, you will need to increase this number
     * accordingly.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimit() {
        return null;
    }

    /**
     * A ServerSideEncryption can be enabled to encrypt assets that are put into assetBucket.
     * <p>
     * Default: - No encryption is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    /**
     * For AWS_KMS ServerSideEncryption a KMS KeyId must be provided which will be used to encrypt assets.
     * <p>
     * Default: - No KMS KeyId and SSE_KMS encryption cannot be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProductStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProductStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProductStackProps> {
        java.lang.Boolean analyticsReporting;
        software.amazon.awscdk.services.s3.IBucket assetBucket;
        java.lang.String description;
        java.lang.Number memoryLimit;
        software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        java.lang.String serverSideEncryptionAwsKmsKeyId;

        /**
         * Sets the value of {@link ProductStackProps#getAnalyticsReporting}
         * @param analyticsReporting Include runtime versioning information in this Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(java.lang.Boolean analyticsReporting) {
            this.analyticsReporting = analyticsReporting;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackProps#getAssetBucket}
         * @param assetBucket A Bucket can be passed to store assets, enabling ProductStack Asset support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetBucket(software.amazon.awscdk.services.s3.IBucket assetBucket) {
            this.assetBucket = assetBucket;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackProps#getDescription}
         * @param description A description of the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackProps#getMemoryLimit}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         *                    If you are deploying large files, you will need to increase this number
         *                    accordingly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(java.lang.Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackProps#getServerSideEncryption}
         * @param serverSideEncryption A ServerSideEncryption can be enabled to encrypt assets that are put into assetBucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackProps#getServerSideEncryptionAwsKmsKeyId}
         * @param serverSideEncryptionAwsKmsKeyId For AWS_KMS ServerSideEncryption a KMS KeyId must be provided which will be used to encrypt assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionAwsKmsKeyId(java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProductStackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProductStackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProductStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductStackProps {
        private final java.lang.Boolean analyticsReporting;
        private final software.amazon.awscdk.services.s3.IBucket assetBucket;
        private final java.lang.String description;
        private final java.lang.Number memoryLimit;
        private final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private final java.lang.String serverSideEncryptionAwsKmsKeyId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analyticsReporting = software.amazon.jsii.Kernel.get(this, "analyticsReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.assetBucket = software.amazon.jsii.Kernel.get(this, "assetBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memoryLimit = software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.serverSideEncryption = software.amazon.jsii.Kernel.get(this, "serverSideEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption.class));
            this.serverSideEncryptionAwsKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionAwsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analyticsReporting = builder.analyticsReporting;
            this.assetBucket = builder.assetBucket;
            this.description = builder.description;
            this.memoryLimit = builder.memoryLimit;
            this.serverSideEncryption = builder.serverSideEncryption;
            this.serverSideEncryptionAwsKmsKeyId = builder.serverSideEncryptionAwsKmsKeyId;
        }

        @Override
        public final java.lang.Boolean getAnalyticsReporting() {
            return this.analyticsReporting;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getAssetBucket() {
            return this.assetBucket;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final java.lang.String getServerSideEncryptionAwsKmsKeyId() {
            return this.serverSideEncryptionAwsKmsKeyId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAnalyticsReporting() != null) {
                data.set("analyticsReporting", om.valueToTree(this.getAnalyticsReporting()));
            }
            if (this.getAssetBucket() != null) {
                data.set("assetBucket", om.valueToTree(this.getAssetBucket()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getServerSideEncryptionAwsKmsKeyId() != null) {
                data.set("serverSideEncryptionAwsKmsKeyId", om.valueToTree(this.getServerSideEncryptionAwsKmsKeyId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.ProductStackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProductStackProps.Jsii$Proxy that = (ProductStackProps.Jsii$Proxy) o;

            if (this.analyticsReporting != null ? !this.analyticsReporting.equals(that.analyticsReporting) : that.analyticsReporting != null) return false;
            if (this.assetBucket != null ? !this.assetBucket.equals(that.assetBucket) : that.assetBucket != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            return this.serverSideEncryptionAwsKmsKeyId != null ? this.serverSideEncryptionAwsKmsKeyId.equals(that.serverSideEncryptionAwsKmsKeyId) : that.serverSideEncryptionAwsKmsKeyId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.analyticsReporting != null ? this.analyticsReporting.hashCode() : 0;
            result = 31 * result + (this.assetBucket != null ? this.assetBucket.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionAwsKmsKeyId != null ? this.serverSideEncryptionAwsKmsKeyId.hashCode() : 0);
            return result;
        }
    }
}
