package software.amazon.awscdk.services.servicediscovery;

/**
 * Properties for defining a <code>CfnInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Object instanceAttributes;
 * CfnInstanceProps cfnInstanceProps = CfnInstanceProps.builder()
 *         .instanceAttributes(instanceAttributes)
 *         .serviceId("serviceId")
 *         // the properties below are optional
 *         .instanceId("instanceId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.860Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A string map that contains the following information for the service that you specify in <code>ServiceId</code> :.
     * <p>
     * <ul>
     * <li>The attributes that apply to the records that are defined in the service.</li>
     * <li>For each attribute, the applicable value.</li>
     * </ul>
     * <p>
     * Supported attribute keys include the following:
     * <p>
     * <ul>
     * <li><strong>AWS_ALIAS_DNS_NAME</strong> - If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that is associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget-&gt;DNSName</a> in the <em>Route 53 API Reference</em> .</li>
     * </ul>
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>The configuration for the service that is specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</li>
     * <li>In the service that is specified by <code>ServiceId</code> , the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code> .</li>
     * <li>If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, AWS Cloud Map will create the health check, but it won't associate the health check with the alias record.</li>
     * <li>Auto naming currently doesn't support creating alias records that route traffic to AWS resources other than ELB load balancers.</li>
     * <li>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code> , don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</li>
     * <li><strong>AWS_EC2_INSTANCE_ID</strong> - <em>HTTP namespaces only.</em> The Amazon EC2 instance ID for the instance. The <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address. When creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> , if the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code> . After the resource has been created, the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</li>
     * <li><strong>AWS_INIT_HEALTH_STATUS</strong> - If the service configuration includes <code>HealthCheckCustomConfig</code> , when creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code> . If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code> , the initial status is <code>HEALTHY</code> . This attribute can only be used when creating resources and will not be seen on existing resources.</li>
     * <li><strong>AWS_INSTANCE_CNAME</strong> - If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries, for example, <code>example.com</code> .</li>
     * </ul>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.
     * <p>
     * <ul>
     * <li><strong>AWS_INSTANCE_IPV4</strong> - If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries, for example, <code>192.0.2.44</code> .</li>
     * </ul>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
     * <p>
     * <ul>
     * <li><strong>AWS_INSTANCE_IPV6</strong> - If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code> .</li>
     * </ul>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
     * <p>
     * <ul>
     * <li><strong>AWS_INSTANCE_PORT</strong> - If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</li>
     * </ul>
     * <p>
     * If the service includes <code>HealthCheckConfig</code> , the port on the endpoint that you want Route 53 to send requests to.
     * <p>
     * This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInstanceAttributes();

    /**
     * The ID or Amazon Resource Name (ARN) of the service that you want to use for settings for the instance.
     * <p>
     * For services created in a shared namespace, specify the service ARN. For more information about shared namespaces, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/sharing-namespaces.html">Cross-account AWS Cloud Map namespace sharing</a> in the <em>AWS Cloud Map Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-serviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-serviceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceId();

    /**
     * An identifier that you want to associate with the instance. Note the following:.
     * <p>
     * <ul>
     * <li>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a> .</li>
     * <li>You can use this value to update an existing instance.</li>
     * <li>To register a new instance, you must specify a value that's unique among instances that you register by using the same service.</li>
     * <li>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code> , AWS Cloud Map updates the existing DNS records, if any. If there's also an existing health check, AWS Cloud Map deletes the old health check and creates a new one.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.
     * <p>
     * </blockquote><blockquote>
     * <p>
     * Do not include sensitive information in <code>InstanceId</code> if the namespace is discoverable by public DNS queries and any <code>Type</code> member of <code>DnsRecord</code> for the service contains <code>SRV</code> because the <code>InstanceId</code> is discoverable by public DNS queries.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        java.lang.Object instanceAttributes;
        java.lang.String serviceId;
        java.lang.String instanceId;

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceAttributes}
         * @param instanceAttributes A string map that contains the following information for the service that you specify in <code>ServiceId</code> :. This parameter is required.
         *                           <ul>
         *                           <li>The attributes that apply to the records that are defined in the service.</li>
         *                           <li>For each attribute, the applicable value.</li>
         *                           </ul>
         *                           <p>
         *                           Supported attribute keys include the following:
         *                           <p>
         *                           <ul>
         *                           <li><strong>AWS_ALIAS_DNS_NAME</strong> - If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that is associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget-&gt;DNSName</a> in the <em>Route 53 API Reference</em> .</li>
         *                           </ul>
         *                           <p>
         *                           Note the following:
         *                           <p>
         *                           <ul>
         *                           <li>The configuration for the service that is specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</li>
         *                           <li>In the service that is specified by <code>ServiceId</code> , the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code> .</li>
         *                           <li>If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, AWS Cloud Map will create the health check, but it won't associate the health check with the alias record.</li>
         *                           <li>Auto naming currently doesn't support creating alias records that route traffic to AWS resources other than ELB load balancers.</li>
         *                           <li>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code> , don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</li>
         *                           <li><strong>AWS_EC2_INSTANCE_ID</strong> - <em>HTTP namespaces only.</em> The Amazon EC2 instance ID for the instance. The <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address. When creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> , if the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code> . After the resource has been created, the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</li>
         *                           <li><strong>AWS_INIT_HEALTH_STATUS</strong> - If the service configuration includes <code>HealthCheckCustomConfig</code> , when creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code> . If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code> , the initial status is <code>HEALTHY</code> . This attribute can only be used when creating resources and will not be seen on existing resources.</li>
         *                           <li><strong>AWS_INSTANCE_CNAME</strong> - If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries, for example, <code>example.com</code> .</li>
         *                           </ul>
         *                           <p>
         *                           This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.
         *                           <p>
         *                           <ul>
         *                           <li><strong>AWS_INSTANCE_IPV4</strong> - If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries, for example, <code>192.0.2.44</code> .</li>
         *                           </ul>
         *                           <p>
         *                           This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
         *                           <p>
         *                           <ul>
         *                           <li><strong>AWS_INSTANCE_IPV6</strong> - If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code> .</li>
         *                           </ul>
         *                           <p>
         *                           This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
         *                           <p>
         *                           <ul>
         *                           <li><strong>AWS_INSTANCE_PORT</strong> - If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</li>
         *                           </ul>
         *                           <p>
         *                           If the service includes <code>HealthCheckConfig</code> , the port on the endpoint that you want Route 53 to send requests to.
         *                           <p>
         *                           This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAttributes(java.lang.Object instanceAttributes) {
            this.instanceAttributes = instanceAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getServiceId}
         * @param serviceId The ID or Amazon Resource Name (ARN) of the service that you want to use for settings for the instance. This parameter is required.
         *                  For services created in a shared namespace, specify the service ARN. For more information about shared namespaces, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/sharing-namespaces.html">Cross-account AWS Cloud Map namespace sharing</a> in the <em>AWS Cloud Map Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceId}
         * @param instanceId An identifier that you want to associate with the instance. Note the following:.
         *                   <ul>
         *                   <li>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a> .</li>
         *                   <li>You can use this value to update an existing instance.</li>
         *                   <li>To register a new instance, you must specify a value that's unique among instances that you register by using the same service.</li>
         *                   <li>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code> , AWS Cloud Map updates the existing DNS records, if any. If there's also an existing health check, AWS Cloud Map deletes the old health check and creates a new one.</li>
         *                   </ul>
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.
         *                   <p>
         *                   </blockquote><blockquote>
         *                   <p>
         *                   Do not include sensitive information in <code>InstanceId</code> if the namespace is discoverable by public DNS queries and any <code>Type</code> member of <code>DnsRecord</code> for the service contains <code>SRV</code> because the <code>InstanceId</code> is discoverable by public DNS queries.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.Object instanceAttributes;
        private final java.lang.String serviceId;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceAttributes = software.amazon.jsii.Kernel.get(this, "instanceAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceId = software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceAttributes = java.util.Objects.requireNonNull(builder.instanceAttributes, "instanceAttributes is required");
            this.serviceId = java.util.Objects.requireNonNull(builder.serviceId, "serviceId is required");
            this.instanceId = builder.instanceId;
        }

        @Override
        public final java.lang.Object getInstanceAttributes() {
            return this.instanceAttributes;
        }

        @Override
        public final java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceAttributes", om.valueToTree(this.getInstanceAttributes()));
            data.set("serviceId", om.valueToTree(this.getServiceId()));
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (!instanceAttributes.equals(that.instanceAttributes)) return false;
            if (!serviceId.equals(that.serviceId)) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceAttributes.hashCode();
            result = 31 * result + (this.serviceId.hashCode());
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
