package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnMailManagerIngressPoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnMailManagerIngressPointProps cfnMailManagerIngressPointProps = CfnMailManagerIngressPointProps.builder()
 *         .ruleSetId("ruleSetId")
 *         .trafficPolicyId("trafficPolicyId")
 *         .type("type")
 *         // the properties below are optional
 *         .ingressPointConfiguration(IngressPointConfigurationProperty.builder()
 *                 .secretArn("secretArn")
 *                 .smtpPassword("smtpPassword")
 *                 .build())
 *         .ingressPointName("ingressPointName")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .privateNetworkConfiguration(PrivateNetworkConfigurationProperty.builder()
 *                         .vpcEndpointId("vpcEndpointId")
 *                         .build())
 *                 .publicNetworkConfiguration(PublicNetworkConfigurationProperty.builder()
 *                         .ipType("ipType")
 *                         .build())
 *                 .build())
 *         .statusToUpdate("statusToUpdate")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.954Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerIngressPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnMailManagerIngressPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMailManagerIngressPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of an existing rule set that you attach to an ingress endpoint resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-rulesetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-rulesetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleSetId();

    /**
     * The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-trafficpolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-trafficpolicyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficPolicyId();

    /**
     * The type of the ingress endpoint to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The configuration of the ingress endpoint resource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ses.CfnMailManagerIngressPoint.IngressPointConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-ingresspointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-ingresspointconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIngressPointConfiguration() {
        return null;
    }

    /**
     * A user friendly name for an ingress endpoint resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-ingresspointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-ingresspointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIngressPointName() {
        return null;
    }

    /**
     * The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ses.CfnMailManagerIngressPoint.NetworkConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-networkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The update status of an ingress endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-statustoupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-statustoupdate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatusToUpdate() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanageringresspoint.html#cfn-ses-mailmanageringresspoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMailManagerIngressPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMailManagerIngressPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMailManagerIngressPointProps> {
        java.lang.String ruleSetId;
        java.lang.String trafficPolicyId;
        java.lang.String type;
        java.lang.Object ingressPointConfiguration;
        java.lang.String ingressPointName;
        java.lang.Object networkConfiguration;
        java.lang.String statusToUpdate;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getRuleSetId}
         * @param ruleSetId The identifier of an existing rule set that you attach to an ingress endpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetId(java.lang.String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getTrafficPolicyId}
         * @param trafficPolicyId The identifier of an existing traffic policy that you attach to an ingress endpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficPolicyId(java.lang.String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getType}
         * @param type The type of the ingress endpoint to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getIngressPointConfiguration}
         * @param ingressPointConfiguration The configuration of the ingress endpoint resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressPointConfiguration(software.amazon.awscdk.IResolvable ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getIngressPointConfiguration}
         * @param ingressPointConfiguration The configuration of the ingress endpoint resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressPointConfiguration(software.amazon.awscdk.services.ses.CfnMailManagerIngressPoint.IngressPointConfigurationProperty ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getIngressPointName}
         * @param ingressPointName A user friendly name for an ingress endpoint resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressPointName(java.lang.String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getNetworkConfiguration}
         * @param networkConfiguration The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getNetworkConfiguration}
         * @param networkConfiguration The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.ses.CfnMailManagerIngressPoint.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getStatusToUpdate}
         * @param statusToUpdate The update status of an ingress endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusToUpdate(java.lang.String statusToUpdate) {
            this.statusToUpdate = statusToUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerIngressPointProps#getTags}
         * @param tags The tags used to organize, track, or control access for the resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMailManagerIngressPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMailManagerIngressPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMailManagerIngressPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMailManagerIngressPointProps {
        private final java.lang.String ruleSetId;
        private final java.lang.String trafficPolicyId;
        private final java.lang.String type;
        private final java.lang.Object ingressPointConfiguration;
        private final java.lang.String ingressPointName;
        private final java.lang.Object networkConfiguration;
        private final java.lang.String statusToUpdate;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ruleSetId = software.amazon.jsii.Kernel.get(this, "ruleSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trafficPolicyId = software.amazon.jsii.Kernel.get(this, "trafficPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ingressPointConfiguration = software.amazon.jsii.Kernel.get(this, "ingressPointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ingressPointName = software.amazon.jsii.Kernel.get(this, "ingressPointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.statusToUpdate = software.amazon.jsii.Kernel.get(this, "statusToUpdate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ruleSetId = java.util.Objects.requireNonNull(builder.ruleSetId, "ruleSetId is required");
            this.trafficPolicyId = java.util.Objects.requireNonNull(builder.trafficPolicyId, "trafficPolicyId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.ingressPointConfiguration = builder.ingressPointConfiguration;
            this.ingressPointName = builder.ingressPointName;
            this.networkConfiguration = builder.networkConfiguration;
            this.statusToUpdate = builder.statusToUpdate;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getRuleSetId() {
            return this.ruleSetId;
        }

        @Override
        public final java.lang.String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getIngressPointConfiguration() {
            return this.ingressPointConfiguration;
        }

        @Override
        public final java.lang.String getIngressPointName() {
            return this.ingressPointName;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.String getStatusToUpdate() {
            return this.statusToUpdate;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ruleSetId", om.valueToTree(this.getRuleSetId()));
            data.set("trafficPolicyId", om.valueToTree(this.getTrafficPolicyId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getIngressPointConfiguration() != null) {
                data.set("ingressPointConfiguration", om.valueToTree(this.getIngressPointConfiguration()));
            }
            if (this.getIngressPointName() != null) {
                data.set("ingressPointName", om.valueToTree(this.getIngressPointName()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getStatusToUpdate() != null) {
                data.set("statusToUpdate", om.valueToTree(this.getStatusToUpdate()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerIngressPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMailManagerIngressPointProps.Jsii$Proxy that = (CfnMailManagerIngressPointProps.Jsii$Proxy) o;

            if (!ruleSetId.equals(that.ruleSetId)) return false;
            if (!trafficPolicyId.equals(that.trafficPolicyId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.ingressPointConfiguration != null ? !this.ingressPointConfiguration.equals(that.ingressPointConfiguration) : that.ingressPointConfiguration != null) return false;
            if (this.ingressPointName != null ? !this.ingressPointName.equals(that.ingressPointName) : that.ingressPointName != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            if (this.statusToUpdate != null ? !this.statusToUpdate.equals(that.statusToUpdate) : that.statusToUpdate != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ruleSetId.hashCode();
            result = 31 * result + (this.trafficPolicyId.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.ingressPointConfiguration != null ? this.ingressPointConfiguration.hashCode() : 0);
            result = 31 * result + (this.ingressPointName != null ? this.ingressPointName.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.statusToUpdate != null ? this.statusToUpdate.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
