package software.amazon.awscdk.services.ssm;

/**
 * The <code>AWS::SSM::Association</code> resource creates a State Manager association for your managed instances.
 * <p>
 * A State Manager association defines the state that you want to maintain on your instances. For example, an association can specify that anti-virus software must be installed and running on your instances, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an AWS Resource Groups or an AWS Auto Scaling Group, State Manager applies the configuration when new instances are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software is not installed, then State Manager installs it. If the software is installed, but the service is not running, then the association might instruct State Manager to start the service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * Object parameters;
 * CfnAssociation cfnAssociation = CfnAssociation.Builder.create(this, "MyCfnAssociation")
 *         .name("name")
 *         // the properties below are optional
 *         .applyOnlyAtCronInterval(false)
 *         .associationName("associationName")
 *         .automationTargetParameterName("automationTargetParameterName")
 *         .calendarNames(List.of("calendarNames"))
 *         .complianceSeverity("complianceSeverity")
 *         .documentVersion("documentVersion")
 *         .instanceId("instanceId")
 *         .maxConcurrency("maxConcurrency")
 *         .maxErrors("maxErrors")
 *         .outputLocation(InstanceAssociationOutputLocationProperty.builder()
 *                 .s3Location(S3OutputLocationProperty.builder()
 *                         .outputS3BucketName("outputS3BucketName")
 *                         .outputS3KeyPrefix("outputS3KeyPrefix")
 *                         .outputS3Region("outputS3Region")
 *                         .build())
 *                 .build())
 *         .parameters(parameters)
 *         .scheduleExpression("scheduleExpression")
 *         .scheduleOffset(123)
 *         .syncCompliance("syncCompliance")
 *         .targets(List.of(TargetProperty.builder()
 *                 .key("key")
 *                 .values(List.of("values"))
 *                 .build()))
 *         .waitForSuccessTimeoutSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.225Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnAssociation")
public class CfnAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ssm.IAssociationRef {

    protected CfnAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssm.CfnAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::SSM::Association</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.CfnAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new IAssociationRef from a associationId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param associationId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ssm.IAssociationRef fromAssociationId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String associationId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.CfnAssociation.class, "fromAssociationId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ssm.IAssociationRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(associationId, "associationId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A reference to a Association resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ssm.AssociationReference getAssociationRef() {
        return software.amazon.jsii.Kernel.get(this, "associationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ssm.AssociationReference.class));
    }

    /**
     * The association ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the SSM document that contains the configuration information for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSM document that contains the configuration information for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplyOnlyAtCronInterval() {
        return software.amazon.jsii.Kernel.get(this, "applyOnlyAtCronInterval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplyOnlyAtCronInterval(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "applyOnlyAtCronInterval", value);
    }

    /**
     * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplyOnlyAtCronInterval(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applyOnlyAtCronInterval", value);
    }

    /**
     * Specify a descriptive name for the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssociationName() {
        return software.amazon.jsii.Kernel.get(this, "associationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify a descriptive name for the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "associationName", value);
    }

    /**
     * Choose the parameter that will define how your automation will branch out.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutomationTargetParameterName() {
        return software.amazon.jsii.Kernel.get(this, "automationTargetParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Choose the parameter that will define how your automation will branch out.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomationTargetParameterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "automationTargetParameterName", value);
    }

    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCalendarNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "calendarNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCalendarNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "calendarNames", value);
    }

    /**
     * The severity level that is assigned to the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComplianceSeverity() {
        return software.amazon.jsii.Kernel.get(this, "complianceSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The severity level that is assigned to the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComplianceSeverity(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "complianceSeverity", value);
    }

    /**
     * The version of the SSM document to associate with the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocumentVersion() {
        return software.amazon.jsii.Kernel.get(this, "documentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the SSM document to associate with the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "documentVersion", value);
    }

    /**
     * <blockquote><p><code>InstanceId</code> has been deprecated.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <blockquote><p><code>InstanceId</code> has been deprecated.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceId", value);
    }

    /**
     * The maximum number of targets allowed to run the association at the same time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaxConcurrency() {
        return software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum number of targets allowed to run the association at the same time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxConcurrency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maxConcurrency", value);
    }

    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaxErrors() {
        return software.amazon.jsii.Kernel.get(this, "maxErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxErrors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maxErrors", value);
    }

    /**
     * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnAssociation.InstanceAssociationOutputLocationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputLocation() {
        return software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnAssociation.InstanceAssociationOutputLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * The parameters for the runtime configuration of the document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters for the runtime configuration of the document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A cron expression that specifies a schedule when the association runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A cron expression that specifies a schedule when the association runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpression", value);
    }

    /**
     * Number of days to wait after the scheduled day to run an association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getScheduleOffset() {
        return software.amazon.jsii.Kernel.get(this, "scheduleOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Number of days to wait after the scheduled day to run an association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleOffset(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scheduleOffset", value);
    }

    /**
     * The mode for generating association compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSyncCompliance() {
        return software.amazon.jsii.Kernel.get(this, "syncCompliance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mode for generating association compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncCompliance(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "syncCompliance", value);
    }

    /**
     * The targets for the association.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnAssociation.TargetProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The targets for the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The targets for the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssm.CfnAssociation.TargetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssm.CfnAssociation.TargetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getWaitForSuccessTimeoutSeconds() {
        return software.amazon.jsii.Kernel.get(this, "waitForSuccessTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWaitForSuccessTimeoutSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "waitForSuccessTimeoutSeconds", value);
    }
    /**
     * <code>InstanceAssociationOutputLocation</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html">AWS::SSM::Association</a> resource that specifies an Amazon S3 bucket where you want to store the results of this association request.
     * <p>
     * For the minimal permissions required to enable Amazon S3 output for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-state-assoc.html">Creating associations</a> in the <em>Systems Manager User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * InstanceAssociationOutputLocationProperty instanceAssociationOutputLocationProperty = InstanceAssociationOutputLocationProperty.builder()
     *         .s3Location(S3OutputLocationProperty.builder()
     *                 .outputS3BucketName("outputS3BucketName")
     *                 .outputS3KeyPrefix("outputS3KeyPrefix")
     *                 .outputS3Region("outputS3Region")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnAssociation.InstanceAssociationOutputLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceAssociationOutputLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceAssociationOutputLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <code>S3OutputLocation</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html">InstanceAssociationOutputLocation</a> property that specifies an Amazon S3 bucket where you want to store the results of this request.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnAssociation.S3OutputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html#cfn-ssm-association-instanceassociationoutputlocation-s3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html#cfn-ssm-association-instanceassociationoutputlocation-s3location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Location() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceAssociationOutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceAssociationOutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceAssociationOutputLocationProperty> {
            java.lang.Object s3Location;

            /**
             * Sets the value of {@link InstanceAssociationOutputLocationProperty#getS3Location}
             * @param s3Location <code>S3OutputLocation</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html">InstanceAssociationOutputLocation</a> property that specifies an Amazon S3 bucket where you want to store the results of this request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Sets the value of {@link InstanceAssociationOutputLocationProperty#getS3Location}
             * @param s3Location <code>S3OutputLocation</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html">InstanceAssociationOutputLocation</a> property that specifies an Amazon S3 bucket where you want to store the results of this request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.services.ssm.CfnAssociation.S3OutputLocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceAssociationOutputLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceAssociationOutputLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceAssociationOutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceAssociationOutputLocationProperty {
            private final java.lang.Object s3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Location = builder.s3Location;
            }

            @Override
            public final java.lang.Object getS3Location() {
                return this.s3Location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Location() != null) {
                    data.set("s3Location", om.valueToTree(this.getS3Location()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnAssociation.InstanceAssociationOutputLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceAssociationOutputLocationProperty.Jsii$Proxy that = (InstanceAssociationOutputLocationProperty.Jsii$Proxy) o;

                return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Location != null ? this.s3Location.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * <code>S3OutputLocation</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html">AWS::SSM::Association</a> resource that specifies an Amazon S3 bucket where you want to store the results of this association request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * S3OutputLocationProperty s3OutputLocationProperty = S3OutputLocationProperty.builder()
     *         .outputS3BucketName("outputS3BucketName")
     *         .outputS3KeyPrefix("outputS3KeyPrefix")
     *         .outputS3Region("outputS3Region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnAssociation.S3OutputLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputS3BucketName() {
            return null;
        }

        /**
         * The S3 bucket subfolder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputS3KeyPrefix() {
            return null;
        }

        /**
         * The AWS Region of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputS3Region() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputLocationProperty> {
            java.lang.String outputS3BucketName;
            java.lang.String outputS3KeyPrefix;
            java.lang.String outputS3Region;

            /**
             * Sets the value of {@link S3OutputLocationProperty#getOutputS3BucketName}
             * @param outputS3BucketName The name of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3BucketName(java.lang.String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputLocationProperty#getOutputS3KeyPrefix}
             * @param outputS3KeyPrefix The S3 bucket subfolder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3KeyPrefix(java.lang.String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputLocationProperty#getOutputS3Region}
             * @param outputS3Region The AWS Region of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3Region(java.lang.String outputS3Region) {
                this.outputS3Region = outputS3Region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputLocationProperty {
            private final java.lang.String outputS3BucketName;
            private final java.lang.String outputS3KeyPrefix;
            private final java.lang.String outputS3Region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputS3BucketName = software.amazon.jsii.Kernel.get(this, "outputS3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputS3KeyPrefix = software.amazon.jsii.Kernel.get(this, "outputS3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputS3Region = software.amazon.jsii.Kernel.get(this, "outputS3Region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputS3BucketName = builder.outputS3BucketName;
                this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
                this.outputS3Region = builder.outputS3Region;
            }

            @Override
            public final java.lang.String getOutputS3BucketName() {
                return this.outputS3BucketName;
            }

            @Override
            public final java.lang.String getOutputS3KeyPrefix() {
                return this.outputS3KeyPrefix;
            }

            @Override
            public final java.lang.String getOutputS3Region() {
                return this.outputS3Region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOutputS3BucketName() != null) {
                    data.set("outputS3BucketName", om.valueToTree(this.getOutputS3BucketName()));
                }
                if (this.getOutputS3KeyPrefix() != null) {
                    data.set("outputS3KeyPrefix", om.valueToTree(this.getOutputS3KeyPrefix()));
                }
                if (this.getOutputS3Region() != null) {
                    data.set("outputS3Region", om.valueToTree(this.getOutputS3Region()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnAssociation.S3OutputLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputLocationProperty.Jsii$Proxy that = (S3OutputLocationProperty.Jsii$Proxy) o;

                if (this.outputS3BucketName != null ? !this.outputS3BucketName.equals(that.outputS3BucketName) : that.outputS3BucketName != null) return false;
                if (this.outputS3KeyPrefix != null ? !this.outputS3KeyPrefix.equals(that.outputS3KeyPrefix) : that.outputS3KeyPrefix != null) return false;
                return this.outputS3Region != null ? this.outputS3Region.equals(that.outputS3Region) : that.outputS3Region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputS3BucketName != null ? this.outputS3BucketName.hashCode() : 0;
                result = 31 * result + (this.outputS3KeyPrefix != null ? this.outputS3KeyPrefix.hashCode() : 0);
                result = 31 * result + (this.outputS3Region != null ? this.outputS3Region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>Target</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html">AWS::SSM::Association</a> resource that specifies the targets for an SSM document in Systems Manager . You can target all instances in an AWS account by specifying the <code>InstanceIds</code> key with a value of <code>*</code> . To view a JSON and a YAML example that targets all instances, see the example "Create an association for all managed instances in an AWS account " later in this page.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * TargetProperty targetProperty = TargetProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnAssociation.TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * User-defined criteria for sending commands that target managed nodes that meet the criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * User-defined criteria that maps to <code>Key</code> .
         * <p>
         * For example, if you specified <code>tag:ServerRole</code> , you could specify <code>value:WebServer</code> to run a command on instances that include EC2 tags of <code>ServerRole,WebServer</code> .
         * <p>
         * Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link TargetProperty#getKey}
             * @param key User-defined criteria for sending commands that target managed nodes that meet the criteria. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getValues}
             * @param values User-defined criteria that maps to <code>Key</code> . This parameter is required.
             *               For example, if you specified <code>tag:ServerRole</code> , you could specify <code>value:WebServer</code> to run a command on instances that include EC2 tags of <code>ServerRole,WebServer</code> .
             *               <p>
             *               Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnAssociation.TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetProperty.Jsii$Proxy that = (TargetProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.CfnAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.CfnAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.CfnAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.CfnAssociationProps.Builder();
        }

        /**
         * The name of the SSM document that contains the configuration information for the instance.
         * <p>
         * You can specify <code>Command</code> or <code>Automation</code> documents. The documents can be AWS -predefined documents, documents you created, or a document that is shared with you from another account. For SSM documents that are shared with you from other AWS accounts , you must specify the complete SSM document ARN, in the following format:
         * <p>
         * <code>arn:partition:ssm:region:account-id:document/document-name</code>
         * <p>
         * For example: <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         * <p>
         * For AWS -predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS -ApplyPatchBaseline</code> or <code>My-Document</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name</a>
         * @param name The name of the SSM document that contains the configuration information for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
         * <p>
         * Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval</a>
         * @param applyOnlyAtCronInterval By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnlyAtCronInterval(final java.lang.Boolean applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }
        /**
         * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
         * <p>
         * Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval</a>
         * @param applyOnlyAtCronInterval By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnlyAtCronInterval(final software.amazon.awscdk.IResolvable applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }

        /**
         * Specify a descriptive name for the association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname</a>
         * @param associationName Specify a descriptive name for the association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationName(final java.lang.String associationName) {
            this.props.associationName(associationName);
            return this;
        }

        /**
         * Choose the parameter that will define how your automation will branch out.
         * <p>
         * This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername</a>
         * @param automationTargetParameterName Choose the parameter that will define how your automation will branch out. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automationTargetParameterName(final java.lang.String automationTargetParameterName) {
            this.props.automationTargetParameterName(automationTargetParameterName);
            return this;
        }

        /**
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under.
         * <p>
         * The associations only run when that Change Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">AWS Systems Manager Change Calendar</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-calendarnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-calendarnames</a>
         * @param calendarNames The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder calendarNames(final java.util.List<java.lang.String> calendarNames) {
            this.props.calendarNames(calendarNames);
            return this;
        }

        /**
         * The severity level that is assigned to the association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity</a>
         * @param complianceSeverity The severity level that is assigned to the association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder complianceSeverity(final java.lang.String complianceSeverity) {
            this.props.complianceSeverity(complianceSeverity);
            return this;
        }

        /**
         * The version of the SSM document to associate with the target.
         * <p>
         * <blockquote>
         * <p>
         * Note the following important information.
         * <p>
         * <ul>
         * <li>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code> .</li>
         * <li><code>DocumentVersion</code> is not valid for documents owned by AWS , such as <code>AWS-RunPatchBaseline</code> or <code>AWS-UpdateSSMAgent</code> . If you specify <code>DocumentVersion</code> for an AWS document, the system returns the following error: "Error occurred during operation 'CreateAssociation'." (RequestToken: <token>, HandlerErrorCode: GeneralServiceException).</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion</a>
         * @param documentVersion The version of the SSM document to associate with the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentVersion(final java.lang.String documentVersion) {
            this.props.documentVersion(documentVersion);
            return this;
        }

        /**
         * <blockquote><p><code>InstanceId</code> has been deprecated.<p></blockquote>
         * <p>
         * To specify an instance ID for an association, use the <code>Targets</code> parameter. If you use the parameter <code>InstanceId</code> , you cannot use the parameters <code>AssociationName</code> , <code>DocumentVersion</code> , <code>MaxErrors</code> , <code>MaxConcurrency</code> , <code>OutputLocation</code> , or <code>ScheduleExpression</code> . To use these parameters, you must use the <code>Targets</code> parameter.
         * <p>
         * <blockquote>
         * <p>
         * Note that in some examples later in this page, <code>InstanceIds</code> is used as the tag-key name in a <code>Targets</code> filter. <code>InstanceId</code> is not used as a parameter.
         * <p>
         * </blockquote>
         * <p>
         * The ID of the instance that the SSM document is associated with. You must specify the <code>InstanceId</code> or <code>Targets</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid</a>
         * @param instanceId <blockquote><p><code>InstanceId</code> has been deprecated.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * The maximum number of targets allowed to run the association at the same time.
         * <p>
         * You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
         * <p>
         * If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency</a>
         * @param maxConcurrency The maximum number of targets allowed to run the association at the same time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(final java.lang.String maxConcurrency) {
            this.props.maxConcurrency(maxConcurrency);
            return this;
        }

        /**
         * The number of errors that are allowed before the system stops sending requests to run the association on additional targets.
         * <p>
         * You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.
         * <p>
         * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors</a>
         * @param maxErrors The number of errors that are allowed before the system stops sending requests to run the association on additional targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxErrors(final java.lang.String maxErrors) {
            this.props.maxErrors(maxErrors);
            return this;
        }

        /**
         * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation</a>
         * @param outputLocation An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }
        /**
         * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation</a>
         * @param outputLocation An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.services.ssm.CfnAssociation.InstanceAssociationOutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        /**
         * The parameters for the runtime configuration of the document.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters</a>
         * @param parameters The parameters for the runtime configuration of the document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A cron expression that specifies a schedule when the association runs.
         * <p>
         * The schedule runs in Coordinated Universal Time (UTC).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression</a>
         * @param scheduleExpression A cron expression that specifies a schedule when the association runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(final java.lang.String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        /**
         * Number of days to wait after the scheduled day to run an association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleoffset</a>
         * @param scheduleOffset Number of days to wait after the scheduled day to run an association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleOffset(final java.lang.Number scheduleOffset) {
            this.props.scheduleOffset(scheduleOffset);
            return this;
        }

        /**
         * The mode for generating association compliance.
         * <p>
         * You can specify <code>AUTO</code> or <code>MANUAL</code> . In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code> . If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code> .
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API action.
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance</a>
         * @param syncCompliance The mode for generating association compliance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncCompliance(final java.lang.String syncCompliance) {
            this.props.syncCompliance(syncCompliance);
            return this;
        }

        /**
         * The targets for the association.
         * <p>
         * You must specify the <code>InstanceId</code> or <code>Targets</code> property. You can target all instances in an AWS account by specifying t he <code>InstanceIds</code> key with a value of <code>*</code> .
         * <p>
         * Supported formats include the following.
         * <p>
         * <ul>
         * <li><code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code></li>
         * <li><code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code></li>
         * </ul>
         * <p>
         * To view a JSON and a YAML example that targets all instances, see "Create an association for all managed instances in an AWS account " on the Examples page.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets</a>
         * @param targets The targets for the association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * The targets for the association.
         * <p>
         * You must specify the <code>InstanceId</code> or <code>Targets</code> property. You can target all instances in an AWS account by specifying t he <code>InstanceIds</code> key with a value of <code>*</code> .
         * <p>
         * Supported formats include the following.
         * <p>
         * <ul>
         * <li><code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code></li>
         * <li><code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code></li>
         * </ul>
         * <p>
         * To view a JSON and a YAML example that targets all instances, see "Create an association for all managed instances in an AWS account " on the Examples page.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets</a>
         * @param targets The targets for the association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends java.lang.Object> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution.
         * <p>
         * If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.
         * <p>
         * <blockquote>
         * <p>
         * When you specify a value for the <code>WaitForSuccessTimeoutSeconds</code> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">drift detection</a> for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include <code>WaitForSuccessTimeoutSeconds</code> in your template.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds</a>
         * @param waitForSuccessTimeoutSeconds The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitForSuccessTimeoutSeconds(final java.lang.Number waitForSuccessTimeoutSeconds) {
            this.props.waitForSuccessTimeoutSeconds(waitForSuccessTimeoutSeconds);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssm.CfnAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.CfnAssociation build() {
            return new software.amazon.awscdk.services.ssm.CfnAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
