package software.amazon.awscdk.services.ssm;

/**
 * Properties for defining a <code>CfnMaintenanceWindowTask</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * Object parameters;
 * Object taskParameters;
 * CfnMaintenanceWindowTaskProps cfnMaintenanceWindowTaskProps = CfnMaintenanceWindowTaskProps.builder()
 *         .priority(123)
 *         .taskArn("taskArn")
 *         .taskType("taskType")
 *         .windowId("windowId")
 *         // the properties below are optional
 *         .cutoffBehavior("cutoffBehavior")
 *         .description("description")
 *         .loggingInfo(LoggingInfoProperty.builder()
 *                 .region("region")
 *                 .s3Bucket("s3Bucket")
 *                 // the properties below are optional
 *                 .s3Prefix("s3Prefix")
 *                 .build())
 *         .maxConcurrency("maxConcurrency")
 *         .maxErrors("maxErrors")
 *         .name("name")
 *         .serviceRoleArn("serviceRoleArn")
 *         .targets(List.of(TargetProperty.builder()
 *                 .key("key")
 *                 .values(List.of("values"))
 *                 .build()))
 *         .taskInvocationParameters(TaskInvocationParametersProperty.builder()
 *                 .maintenanceWindowAutomationParameters(MaintenanceWindowAutomationParametersProperty.builder()
 *                         .documentVersion("documentVersion")
 *                         .parameters(parameters)
 *                         .build())
 *                 .maintenanceWindowLambdaParameters(MaintenanceWindowLambdaParametersProperty.builder()
 *                         .clientContext("clientContext")
 *                         .payload("payload")
 *                         .qualifier("qualifier")
 *                         .build())
 *                 .maintenanceWindowRunCommandParameters(MaintenanceWindowRunCommandParametersProperty.builder()
 *                         .cloudWatchOutputConfig(CloudWatchOutputConfigProperty.builder()
 *                                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
 *                                 .cloudWatchOutputEnabled(false)
 *                                 .build())
 *                         .comment("comment")
 *                         .documentHash("documentHash")
 *                         .documentHashType("documentHashType")
 *                         .documentVersion("documentVersion")
 *                         .notificationConfig(NotificationConfigProperty.builder()
 *                                 .notificationArn("notificationArn")
 *                                 // the properties below are optional
 *                                 .notificationEvents(List.of("notificationEvents"))
 *                                 .notificationType("notificationType")
 *                                 .build())
 *                         .outputS3BucketName("outputS3BucketName")
 *                         .outputS3KeyPrefix("outputS3KeyPrefix")
 *                         .parameters(parameters)
 *                         .serviceRoleArn("serviceRoleArn")
 *                         .timeoutSeconds(123)
 *                         .build())
 *                 .maintenanceWindowStepFunctionsParameters(MaintenanceWindowStepFunctionsParametersProperty.builder()
 *                         .input("input")
 *                         .name("name")
 *                         .build())
 *                 .build())
 *         .taskParameters(taskParameters)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.259Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTaskProps")
@software.amazon.jsii.Jsii.Proxy(CfnMaintenanceWindowTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMaintenanceWindowTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The priority of the task in the maintenance window.
     * <p>
     * The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * The resource that the task uses during execution.
     * <p>
     * For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, <code>TaskArn</code> is the SSM document name or Amazon Resource Name (ARN).
     * <p>
     * For <code>LAMBDA</code> tasks, <code>TaskArn</code> is the function name or ARN.
     * <p>
     * For <code>STEP_FUNCTIONS</code> tasks, <code>TaskArn</code> is the state machine ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTaskArn();

    /**
     * The type of task.
     * <p>
     * Valid values: <code>RUN_COMMAND</code> , <code>AUTOMATION</code> , <code>LAMBDA</code> , <code>STEP_FUNCTIONS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTaskType();

    /**
     * The ID of the maintenance window where the task is registered.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWindowId();

    /**
     * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-cutoffbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-cutoffbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCutoffBehavior() {
        return null;
    }

    /**
     * A description of the task.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * <blockquote><p><code>LoggingInfo</code> has been deprecated.<p></blockquote>
     * <p>
     * To specify an Amazon S3 bucket to contain logs for Run Command tasks, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
     * <p>
     * Information about an Amazon S3 bucket to write Run Command task-level logs to.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.LoggingInfoProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingInfo() {
        return null;
    }

    /**
     * The maximum number of targets this task can be run for, in parallel.
     * <p>
     * <blockquote>
     * <p>
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
     * <p>
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxConcurrency() {
        return null;
    }

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     * <p>
     * <blockquote>
     * <p>
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
     * <p>
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxErrors() {
        return null;
    }

    /**
     * The task name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
     * <p>
     * If you do not specify a service role ARN, Systems Manager uses a service-linked role in your account. If no appropriate service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code> .
     * <p>
     * However, for an improved security posture, we strongly recommend creating a custom policy and custom service role for running your maintenance window tasks. The policy can be crafted to provide only the permissions needed for your particular maintenance window tasks. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html">Setting up Maintenance Windows</a> in the in the <em>AWS Systems Manager User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRoleArn() {
        return null;
    }

    /**
     * The targets, either instances or window target IDs.
     * <p>
     * <ul>
     * <li>Specify instances using <code>Key=InstanceIds,Values= *instanceid1* , *instanceid2*</code> .</li>
     * <li>Specify window target IDs using <code>Key=WindowTargetIds,Values= *window-target-id-1* , *window-target-id-2*</code> .</li>
     * </ul>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TargetProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return null;
    }

    /**
     * The parameters to pass to the task when it runs.
     * <p>
     * Populate only the fields that match the task type. All other fields should be empty.
     * <p>
     * <blockquote>
     * <p>
     * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code> , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you do not specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code> , <code>NotificationConfig</code> , and <code>OutputS3BucketName</code> . If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.
     * <p>
     * </blockquote>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaskInvocationParameters() {
        return null;
    }

    /**
     * <blockquote><p><code>TaskParameters</code> has been deprecated.<p></blockquote>
     * <p>
     * To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_MaintenanceWindowTaskInvocationParameters.html">MaintenanceWindowTaskInvocationParameters</a> .
     * <p>
     * The parameters to pass to the task when it runs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaskParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMaintenanceWindowTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMaintenanceWindowTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMaintenanceWindowTaskProps> {
        java.lang.Number priority;
        java.lang.String taskArn;
        java.lang.String taskType;
        java.lang.String windowId;
        java.lang.String cutoffBehavior;
        java.lang.String description;
        java.lang.Object loggingInfo;
        java.lang.String maxConcurrency;
        java.lang.String maxErrors;
        java.lang.String name;
        java.lang.String serviceRoleArn;
        java.lang.Object targets;
        java.lang.Object taskInvocationParameters;
        java.lang.Object taskParameters;

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getPriority}
         * @param priority The priority of the task in the maintenance window. This parameter is required.
         *                 The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTaskArn}
         * @param taskArn The resource that the task uses during execution. This parameter is required.
         *                For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, <code>TaskArn</code> is the SSM document name or Amazon Resource Name (ARN).
         *                <p>
         *                For <code>LAMBDA</code> tasks, <code>TaskArn</code> is the function name or ARN.
         *                <p>
         *                For <code>STEP_FUNCTIONS</code> tasks, <code>TaskArn</code> is the state machine ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskArn(java.lang.String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTaskType}
         * @param taskType The type of task. This parameter is required.
         *                 Valid values: <code>RUN_COMMAND</code> , <code>AUTOMATION</code> , <code>LAMBDA</code> , <code>STEP_FUNCTIONS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskType(java.lang.String taskType) {
            this.taskType = taskType;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getWindowId}
         * @param windowId The ID of the maintenance window where the task is registered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowId(java.lang.String windowId) {
            this.windowId = windowId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getCutoffBehavior}
         * @param cutoffBehavior The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cutoffBehavior(java.lang.String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getDescription}
         * @param description A description of the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getLoggingInfo}
         * @param loggingInfo <blockquote><p><code>LoggingInfo</code> has been deprecated.<p></blockquote>
         *                    To specify an Amazon S3 bucket to contain logs for Run Command tasks, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
         *                    <p>
         *                    Information about an Amazon S3 bucket to write Run Command task-level logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(software.amazon.awscdk.IResolvable loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getLoggingInfo}
         * @param loggingInfo <blockquote><p><code>LoggingInfo</code> has been deprecated.<p></blockquote>
         *                    To specify an Amazon S3 bucket to contain logs for Run Command tasks, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
         *                    <p>
         *                    Information about an Amazon S3 bucket to write Run Command task-level logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.LoggingInfoProperty loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getMaxConcurrency}
         * @param maxConcurrency The maximum number of targets this task can be run for, in parallel.
         *                       <blockquote>
         *                       <p>
         *                       Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
         *                       <p>
         *                       For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getMaxErrors}
         * @param maxErrors The maximum number of errors allowed before this task stops being scheduled.
         *                  <blockquote>
         *                  <p>
         *                  Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
         *                  <p>
         *                  For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxErrors(java.lang.String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getName}
         * @param name The task name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getServiceRoleArn}
         * @param serviceRoleArn The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
         *                       If you do not specify a service role ARN, Systems Manager uses a service-linked role in your account. If no appropriate service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code> .
         *                       <p>
         *                       However, for an improved security posture, we strongly recommend creating a custom policy and custom service role for running your maintenance window tasks. The policy can be crafted to provide only the permissions needed for your particular maintenance window tasks. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html">Setting up Maintenance Windows</a> in the in the <em>AWS Systems Manager User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTargets}
         * @param targets The targets, either instances or window target IDs.
         *                <ul>
         *                <li>Specify instances using <code>Key=InstanceIds,Values= *instanceid1* , *instanceid2*</code> .</li>
         *                <li>Specify window target IDs using <code>Key=WindowTargetIds,Values= *window-target-id-1* , *window-target-id-2*</code> .</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTargets}
         * @param targets The targets, either instances or window target IDs.
         *                <ul>
         *                <li>Specify instances using <code>Key=InstanceIds,Values= *instanceid1* , *instanceid2*</code> .</li>
         *                <li>Specify window target IDs using <code>Key=WindowTargetIds,Values= *window-target-id-1* , *window-target-id-2*</code> .</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTaskInvocationParameters}
         * @param taskInvocationParameters The parameters to pass to the task when it runs.
         *                                 Populate only the fields that match the task type. All other fields should be empty.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code> , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you do not specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code> , <code>NotificationConfig</code> , and <code>OutputS3BucketName</code> . If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskInvocationParameters(software.amazon.awscdk.IResolvable taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTaskInvocationParameters}
         * @param taskInvocationParameters The parameters to pass to the task when it runs.
         *                                 Populate only the fields that match the task type. All other fields should be empty.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code> , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you do not specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code> , <code>NotificationConfig</code> , and <code>OutputS3BucketName</code> . If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskInvocationParameters(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMaintenanceWindowTaskProps#getTaskParameters}
         * @param taskParameters <blockquote><p><code>TaskParameters</code> has been deprecated.<p></blockquote>
         *                       To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_MaintenanceWindowTaskInvocationParameters.html">MaintenanceWindowTaskInvocationParameters</a> .
         *                       <p>
         *                       The parameters to pass to the task when it runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskParameters(java.lang.Object taskParameters) {
            this.taskParameters = taskParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMaintenanceWindowTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMaintenanceWindowTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMaintenanceWindowTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMaintenanceWindowTaskProps {
        private final java.lang.Number priority;
        private final java.lang.String taskArn;
        private final java.lang.String taskType;
        private final java.lang.String windowId;
        private final java.lang.String cutoffBehavior;
        private final java.lang.String description;
        private final java.lang.Object loggingInfo;
        private final java.lang.String maxConcurrency;
        private final java.lang.String maxErrors;
        private final java.lang.String name;
        private final java.lang.String serviceRoleArn;
        private final java.lang.Object targets;
        private final java.lang.Object taskInvocationParameters;
        private final java.lang.Object taskParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.taskArn = software.amazon.jsii.Kernel.get(this, "taskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.taskType = software.amazon.jsii.Kernel.get(this, "taskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.windowId = software.amazon.jsii.Kernel.get(this, "windowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cutoffBehavior = software.amazon.jsii.Kernel.get(this, "cutoffBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingInfo = software.amazon.jsii.Kernel.get(this, "loggingInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxErrors = software.amazon.jsii.Kernel.get(this, "maxErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.taskInvocationParameters = software.amazon.jsii.Kernel.get(this, "taskInvocationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.taskParameters = software.amazon.jsii.Kernel.get(this, "taskParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.taskArn = java.util.Objects.requireNonNull(builder.taskArn, "taskArn is required");
            this.taskType = java.util.Objects.requireNonNull(builder.taskType, "taskType is required");
            this.windowId = java.util.Objects.requireNonNull(builder.windowId, "windowId is required");
            this.cutoffBehavior = builder.cutoffBehavior;
            this.description = builder.description;
            this.loggingInfo = builder.loggingInfo;
            this.maxConcurrency = builder.maxConcurrency;
            this.maxErrors = builder.maxErrors;
            this.name = builder.name;
            this.serviceRoleArn = builder.serviceRoleArn;
            this.targets = builder.targets;
            this.taskInvocationParameters = builder.taskInvocationParameters;
            this.taskParameters = builder.taskParameters;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final java.lang.String getTaskType() {
            return this.taskType;
        }

        @Override
        public final java.lang.String getWindowId() {
            return this.windowId;
        }

        @Override
        public final java.lang.String getCutoffBehavior() {
            return this.cutoffBehavior;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getLoggingInfo() {
            return this.loggingInfo;
        }

        @Override
        public final java.lang.String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.lang.String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.Object getTaskInvocationParameters() {
            return this.taskInvocationParameters;
        }

        @Override
        public final java.lang.Object getTaskParameters() {
            return this.taskParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("priority", om.valueToTree(this.getPriority()));
            data.set("taskArn", om.valueToTree(this.getTaskArn()));
            data.set("taskType", om.valueToTree(this.getTaskType()));
            data.set("windowId", om.valueToTree(this.getWindowId()));
            if (this.getCutoffBehavior() != null) {
                data.set("cutoffBehavior", om.valueToTree(this.getCutoffBehavior()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLoggingInfo() != null) {
                data.set("loggingInfo", om.valueToTree(this.getLoggingInfo()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getMaxErrors() != null) {
                data.set("maxErrors", om.valueToTree(this.getMaxErrors()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getServiceRoleArn() != null) {
                data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getTaskInvocationParameters() != null) {
                data.set("taskInvocationParameters", om.valueToTree(this.getTaskInvocationParameters()));
            }
            if (this.getTaskParameters() != null) {
                data.set("taskParameters", om.valueToTree(this.getTaskParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMaintenanceWindowTaskProps.Jsii$Proxy that = (CfnMaintenanceWindowTaskProps.Jsii$Proxy) o;

            if (!priority.equals(that.priority)) return false;
            if (!taskArn.equals(that.taskArn)) return false;
            if (!taskType.equals(that.taskType)) return false;
            if (!windowId.equals(that.windowId)) return false;
            if (this.cutoffBehavior != null ? !this.cutoffBehavior.equals(that.cutoffBehavior) : that.cutoffBehavior != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.loggingInfo != null ? !this.loggingInfo.equals(that.loggingInfo) : that.loggingInfo != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.maxErrors != null ? !this.maxErrors.equals(that.maxErrors) : that.maxErrors != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.serviceRoleArn != null ? !this.serviceRoleArn.equals(that.serviceRoleArn) : that.serviceRoleArn != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.taskInvocationParameters != null ? !this.taskInvocationParameters.equals(that.taskInvocationParameters) : that.taskInvocationParameters != null) return false;
            return this.taskParameters != null ? this.taskParameters.equals(that.taskParameters) : that.taskParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.priority.hashCode();
            result = 31 * result + (this.taskArn.hashCode());
            result = 31 * result + (this.taskType.hashCode());
            result = 31 * result + (this.windowId.hashCode());
            result = 31 * result + (this.cutoffBehavior != null ? this.cutoffBehavior.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.loggingInfo != null ? this.loggingInfo.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.maxErrors != null ? this.maxErrors.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.serviceRoleArn != null ? this.serviceRoleArn.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.taskInvocationParameters != null ? this.taskInvocationParameters.hashCode() : 0);
            result = 31 * result + (this.taskParameters != null ? this.taskParameters.hashCode() : 0);
            return result;
        }
    }
}
