package software.amazon.awscdk.services.ssm;

/**
 * Creates a new StringList SSM Parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StringListParameter.valueForTypedListParameter(this, "/My/Public/Parameter", ParameterValueType.AWS_EC2_IMAGE_ID);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.291Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.StringListParameter")
public class StringListParameter extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ssm.IStringListParameter, software.amazon.awscdk.services.ssm.IParameter {

    protected StringListParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringListParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssm.StringListParameter.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StringListParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.StringListParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an external string list parameter with name and optional version.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringListParameter fromListParameterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.ListParameterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringListParameter.class, "fromListParameterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringListParameter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Imports an external parameter of type string list.
     * <p>
     * Returns a token and should not be parsed.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param stringListParameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringListParameter fromStringListParameterName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String stringListParameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringListParameter.class, "fromStringListParameterName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringListParameter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(stringListParameterName, "stringListParameterName is required") });
    }

    /**
     * Returns a token that will resolve (during deployment) to the list value of an SSM StringList parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type the type of the SSM list parameter.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> valueForTypedListParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterValueType type, final @org.jetbrains.annotations.Nullable java.lang.Number version) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringListParameter.class, "valueForTypedListParameter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type, version }));
    }

    /**
     * Returns a token that will resolve (during deployment) to the list value of an SSM StringList parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type the type of the SSM list parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> valueForTypedListParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterValueType type) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringListParameter.class, "valueForTypedListParameter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type }));
    }

    /**
     * Returns a token that will resolve (during deployment) to the list value of an SSM StringList parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> valueForTypedListParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringListParameter.class, "valueForTypedListParameter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required") }));
    }

    /**
     * Grants read (DescribeParameter, GetParameters, GetParameter, GetParameterHistory) permissions on the SSM Parameter.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants write (PutParameter) permissions on the SSM Parameter.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterArn() {
        return software.amazon.jsii.Kernel.get(this, "parameterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterName() {
        return software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterType() {
        return software.amazon.jsii.Kernel.get(this, "parameterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parameter value.
     * <p>
     * Value must not nest another parameter. Do not use {{}} in the value. Values in the array
     * cannot contain commas (<code>,</code>).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStringListValue() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stringListValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The encryption key that is used to encrypt this parameter.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.StringListParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.StringListParameter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.StringListParameterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.StringListParameterProps.Builder();
        }

        /**
         * A regular expression used to validate the parameter value.
         * <p>
         * For example, for String types with values restricted to
         * numbers, you can specify the following: <code>^\d+$</code>
         * <p>
         * Default: no validation is performed
         * <p>
         * @return {@code this}
         * @param allowedPattern A regular expression used to validate the parameter value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(final java.lang.String allowedPattern) {
            this.props.allowedPattern(allowedPattern);
            return this;
        }

        /**
         * Information about the parameter that you want to add to the system.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description Information about the parameter that you want to add to the system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the parameter.
         * <p>
         * Default: - a name will be generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param parameterName The name of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(final java.lang.String parameterName) {
            this.props.parameterName(parameterName);
            return this;
        }

        /**
         * Indicates whether the parameter name is a simple name.
         * <p>
         * A parameter name
         * without any "/" is considered a simple name. If the parameter name includes
         * "/", setting simpleName to true might cause unintended issues such
         * as duplicate "/" in the resulting ARN.
         * <p>
         * This is required only if <code>parameterName</code> is a token, which means we
         * are unable to detect if the name is simple or "path-like" for the purpose
         * of rendering SSM parameter ARNs.
         * <p>
         * If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         * undefined) since the name generated by AWS CloudFormation is always a
         * simple name.
         * <p>
         * Default: - auto-detect based on `parameterName`
         * <p>
         * @return {@code this}
         * @param simpleName Indicates whether the parameter name is a simple name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(final java.lang.Boolean simpleName) {
            this.props.simpleName(simpleName);
            return this;
        }

        /**
         * The tier of the string parameter.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param tier The tier of the string parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final software.amazon.awscdk.services.ssm.ParameterTier tier) {
            this.props.tier(tier);
            return this;
        }

        /**
         * The values of the parameter.
         * <p>
         * It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
         * <p>
         * @return {@code this}
         * @param stringListValue The values of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringListValue(final java.util.List<java.lang.String> stringListValue) {
            this.props.stringListValue(stringListValue);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssm.StringListParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.StringListParameter build() {
            return new software.amazon.awscdk.services.ssm.StringListParameter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
