package software.amazon.awscdk.services.ssmquicksetup;

/**
 * Properties for defining a <code>CfnLifecycleAutomation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmquicksetup.*;
 * CfnLifecycleAutomationProps cfnLifecycleAutomationProps = CfnLifecycleAutomationProps.builder()
 *         .automationDocument("automationDocument")
 *         .automationParameters(Map.of(
 *                 "automationParametersKey", List.of("automationParameters")))
 *         .resourceKey("resourceKey")
 *         // the properties below are optional
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmquicksetup.CfnLifecycleAutomationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLifecycleAutomationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLifecycleAutomationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the SSM Automation document to execute in response to AWS CloudFormation lifecycle events (CREATE, UPDATE, DELETE).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-automationdocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-automationdocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutomationDocument();

    /**
     * A map of key-value parameters passed to the Automation document during execution.
     * <p>
     * Each parameter name maps to a list of values, even for single values. Parameters can include configuration-specific values for your automation workflow.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, List<{@link java.lang.String}>>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-automationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-automationparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAutomationParameters();

    /**
     * A unique identifier used for generating the SSM Association name.
     * <p>
     * This ensures uniqueness when multiple lifecycle automation resources exist in the same stack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-resourcekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-resourcekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceKey();

    /**
     * Tags applied to the underlying SSM Association created by this resource.
     * <p>
     * Tags help identify and organize automation executions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-lifecycleautomation.html#cfn-ssmquicksetup-lifecycleautomation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLifecycleAutomationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLifecycleAutomationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLifecycleAutomationProps> {
        java.lang.String automationDocument;
        java.lang.Object automationParameters;
        java.lang.String resourceKey;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnLifecycleAutomationProps#getAutomationDocument}
         * @param automationDocument The name of the SSM Automation document to execute in response to AWS CloudFormation lifecycle events (CREATE, UPDATE, DELETE). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automationDocument(java.lang.String automationDocument) {
            this.automationDocument = automationDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecycleAutomationProps#getAutomationParameters}
         * @param automationParameters A map of key-value parameters passed to the Automation document during execution. This parameter is required.
         *                             Each parameter name maps to a list of values, even for single values. Parameters can include configuration-specific values for your automation workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automationParameters(software.amazon.awscdk.IResolvable automationParameters) {
            this.automationParameters = automationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecycleAutomationProps#getAutomationParameters}
         * @param automationParameters A map of key-value parameters passed to the Automation document during execution. This parameter is required.
         *                             Each parameter name maps to a list of values, even for single values. Parameters can include configuration-specific values for your automation workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automationParameters(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> automationParameters) {
            this.automationParameters = automationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecycleAutomationProps#getResourceKey}
         * @param resourceKey A unique identifier used for generating the SSM Association name. This parameter is required.
         *                    This ensures uniqueness when multiple lifecycle automation resources exist in the same stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceKey(java.lang.String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecycleAutomationProps#getTags}
         * @param tags Tags applied to the underlying SSM Association created by this resource.
         *             Tags help identify and organize automation executions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLifecycleAutomationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLifecycleAutomationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLifecycleAutomationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLifecycleAutomationProps {
        private final java.lang.String automationDocument;
        private final java.lang.Object automationParameters;
        private final java.lang.String resourceKey;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.automationDocument = software.amazon.jsii.Kernel.get(this, "automationDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automationParameters = software.amazon.jsii.Kernel.get(this, "automationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceKey = software.amazon.jsii.Kernel.get(this, "resourceKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.automationDocument = java.util.Objects.requireNonNull(builder.automationDocument, "automationDocument is required");
            this.automationParameters = java.util.Objects.requireNonNull(builder.automationParameters, "automationParameters is required");
            this.resourceKey = java.util.Objects.requireNonNull(builder.resourceKey, "resourceKey is required");
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAutomationDocument() {
            return this.automationDocument;
        }

        @Override
        public final java.lang.Object getAutomationParameters() {
            return this.automationParameters;
        }

        @Override
        public final java.lang.String getResourceKey() {
            return this.resourceKey;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("automationDocument", om.valueToTree(this.getAutomationDocument()));
            data.set("automationParameters", om.valueToTree(this.getAutomationParameters()));
            data.set("resourceKey", om.valueToTree(this.getResourceKey()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmquicksetup.CfnLifecycleAutomationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLifecycleAutomationProps.Jsii$Proxy that = (CfnLifecycleAutomationProps.Jsii$Proxy) o;

            if (!automationDocument.equals(that.automationDocument)) return false;
            if (!automationParameters.equals(that.automationParameters)) return false;
            if (!resourceKey.equals(that.resourceKey)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.automationDocument.hashCode();
            result = 31 * result + (this.automationParameters.hashCode());
            result = 31 * result + (this.resourceKey.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
