package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a new Step Functions Activity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.*;
 * Key kmsKey = new Key(this, "Key");
 * Activity activity = Activity.Builder.create(this, "ActivityWithCMKEncryptionConfiguration")
 *         .activityName("ActivityWithCMKEncryptionConfiguration")
 *         .encryptionConfiguration(new CustomerManagedEncryptionConfiguration(kmsKey, Duration.seconds(75)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ActivityProps")
@software.amazon.jsii.Jsii.Proxy(ActivityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActivityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for this activity.
     * <p>
     * Default: - If not supplied, a name is generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getActivityName() {
        return null;
    }

    /**
     * The encryptionConfiguration object used for server-side encryption of the activity inputs.
     * <p>
     * Default: - data is transparently encrypted using an AWS owned key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration getEncryptionConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActivityProps> {
        java.lang.String activityName;
        software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration;

        /**
         * Sets the value of {@link ActivityProps#getActivityName}
         * @param activityName The name for this activity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activityName(java.lang.String activityName) {
            this.activityName = activityName;
            return this;
        }

        /**
         * Sets the value of {@link ActivityProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryptionConfiguration object used for server-side encryption of the activity inputs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActivityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActivityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActivityProps {
        private final java.lang.String activityName;
        private final software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.activityName = software.amazon.jsii.Kernel.get(this, "activityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.activityName = builder.activityName;
            this.encryptionConfiguration = builder.encryptionConfiguration;
        }

        @Override
        public final java.lang.String getActivityName() {
            return this.activityName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActivityName() != null) {
                data.set("activityName", om.valueToTree(this.getActivityName()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ActivityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActivityProps.Jsii$Proxy that = (ActivityProps.Jsii$Proxy) o;

            if (this.activityName != null ? !this.activityName.equals(that.activityName) : that.activityName != null) return false;
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.activityName != null ? this.activityName.hashCode() : 0;
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            return result;
        }
    }
}
