package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a <code>CfnStateMachine</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object definition;
 * CfnStateMachineProps cfnStateMachineProps = CfnStateMachineProps.builder()
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .definition(definition)
 *         .definitionS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .key("key")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .definitionString("definitionString")
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", "definitionSubstitutions"))
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .kmsDataKeyReusePeriodSeconds(123)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LogDestinationProperty.builder()
 *                         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .build()))
 *                 .includeExecutionData(false)
 *                 .level("level")
 *                 .build())
 *         .stateMachineName("stateMachineName")
 *         .stateMachineType("stateMachineType")
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tracingConfiguration(TracingConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.417Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineProps")
@software.amazon.jsii.Jsii.Proxy(CfnStateMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStateMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return null;
    }

    /**
     * The name of the S3 bucket where the state machine definition is stored.
     * <p>
     * The state machine definition must be a JSON or YAML file.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitions3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitions3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionS3Location() {
        return null;
    }

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinitionString() {
        return null;
    }

    /**
     * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
     * <p>
     * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
     * <p>
     * Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionsubstitutions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return null;
    }

    /**
     * Encryption configuration for the state machine.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine.EncryptionConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * <blockquote>
     * <p>
     * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
     * <p>
     * </blockquote>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-loggingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return null;
    }

    /**
     * The name of the state machine.
     * <p>
     * A name must <em>not</em> contain:
     * <p>
     * <ul>
     * <li>white space</li>
     * <li>brackets <code>&lt; &gt; { } [ ]</code></li>
     * <li>wildcard characters <code>? *</code></li>
     * <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
     * <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineName() {
        return null;
    }

    /**
     * Determines whether a <code>STANDARD</code> or <code>EXPRESS</code> state machine is created.
     * <p>
     * The default is <code>STANDARD</code> . You cannot update the <code>type</code> of a state machine once it has been created. For more information on <code>STANDARD</code> and <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineType() {
        return null;
    }

    /**
     * The list of tags to add to a resource.
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + -
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> getTags() {
        return null;
    }

    /**
     * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TracingConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tracingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tracingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTracingConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStateMachineProps> {
        java.lang.String roleArn;
        java.lang.Object definition;
        java.lang.Object definitionS3Location;
        java.lang.String definitionString;
        java.lang.Object definitionSubstitutions;
        java.lang.Object encryptionConfiguration;
        java.lang.Object loggingConfiguration;
        java.lang.String stateMachineName;
        java.lang.String stateMachineType;
        java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> tags;
        java.lang.Object tracingConfiguration;

        /**
         * Sets the value of {@link CfnStateMachineProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role to use for this state machine. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinition}
         * @param definition The Amazon States Language definition of the state machine.
         *                   The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(java.lang.Object definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionS3Location}
         * @param definitionS3Location The name of the S3 bucket where the state machine definition is stored.
         *                             The state machine definition must be a JSON or YAML file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(software.amazon.awscdk.IResolvable definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionS3Location}
         * @param definitionS3Location The name of the S3 bucket where the state machine definition is stored.
         *                             The state machine definition must be a JSON or YAML file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionString}
         * @param definitionString The Amazon States Language definition of the state machine.
         *                         The state machine definition must be in JSON. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionString(java.lang.String definitionString) {
            this.definitionString = definitionString;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
         *                                This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
         *                                <p>
         *                                Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
         *                                This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
         *                                <p>
         *                                Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(software.amazon.awscdk.IResolvable definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Encryption configuration for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Encryption configuration for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getLoggingConfiguration}
         * @param loggingConfiguration Defines what execution history events are logged and where they are logged.
         *                             <blockquote>
         *                             <p>
         *                             By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getLoggingConfiguration}
         * @param loggingConfiguration Defines what execution history events are logged and where they are logged.
         *                             <blockquote>
         *                             <p>
         *                             By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getStateMachineName}
         * @param stateMachineName The name of the state machine.
         *                         A name must <em>not</em> contain:
         *                         <p>
         *                         <ul>
         *                         <li>white space</li>
         *                         <li>brackets <code>&lt; &gt; { } [ ]</code></li>
         *                         <li>wildcard characters <code>? *</code></li>
         *                         <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
         *                         <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
         *                         </ul>
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineName(java.lang.String stateMachineName) {
            this.stateMachineName = stateMachineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getStateMachineType}
         * @param stateMachineType Determines whether a <code>STANDARD</code> or <code>EXPRESS</code> state machine is created.
         *                         The default is <code>STANDARD</code> . You cannot update the <code>type</code> of a state machine once it has been created. For more information on <code>STANDARD</code> and <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineType(java.lang.String stateMachineType) {
            this.stateMachineType = stateMachineType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTags}
         * @param tags The list of tags to add to a resource.
         *             Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + -
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTracingConfiguration}
         * @param tracingConfiguration Selects whether or not the state machine's AWS X-Ray tracing is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfiguration(software.amazon.awscdk.IResolvable tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTracingConfiguration}
         * @param tracingConfiguration Selects whether or not the state machine's AWS X-Ray tracing is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfiguration(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TracingConfigurationProperty tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStateMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStateMachineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStateMachineProps {
        private final java.lang.String roleArn;
        private final java.lang.Object definition;
        private final java.lang.Object definitionS3Location;
        private final java.lang.String definitionString;
        private final java.lang.Object definitionSubstitutions;
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.Object loggingConfiguration;
        private final java.lang.String stateMachineName;
        private final java.lang.String stateMachineType;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> tags;
        private final java.lang.Object tracingConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionS3Location = software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionString = software.amazon.jsii.Kernel.get(this, "definitionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definitionSubstitutions = software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loggingConfiguration = software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateMachineType = software.amazon.jsii.Kernel.get(this, "stateMachineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty.class)));
            this.tracingConfiguration = software.amazon.jsii.Kernel.get(this, "tracingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.definition = builder.definition;
            this.definitionS3Location = builder.definitionS3Location;
            this.definitionString = builder.definitionString;
            this.definitionSubstitutions = builder.definitionSubstitutions;
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.loggingConfiguration = builder.loggingConfiguration;
            this.stateMachineName = builder.stateMachineName;
            this.stateMachineType = builder.stateMachineType;
            this.tags = (java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty>)builder.tags;
            this.tracingConfiguration = builder.tracingConfiguration;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.Object getDefinitionS3Location() {
            return this.definitionS3Location;
        }

        @Override
        public final java.lang.String getDefinitionString() {
            return this.definitionString;
        }

        @Override
        public final java.lang.Object getDefinitionSubstitutions() {
            return this.definitionSubstitutions;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.Object getLoggingConfiguration() {
            return this.loggingConfiguration;
        }

        @Override
        public final java.lang.String getStateMachineName() {
            return this.stateMachineName;
        }

        @Override
        public final java.lang.String getStateMachineType() {
            return this.stateMachineType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTracingConfiguration() {
            return this.tracingConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionS3Location() != null) {
                data.set("definitionS3Location", om.valueToTree(this.getDefinitionS3Location()));
            }
            if (this.getDefinitionString() != null) {
                data.set("definitionString", om.valueToTree(this.getDefinitionString()));
            }
            if (this.getDefinitionSubstitutions() != null) {
                data.set("definitionSubstitutions", om.valueToTree(this.getDefinitionSubstitutions()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getLoggingConfiguration() != null) {
                data.set("loggingConfiguration", om.valueToTree(this.getLoggingConfiguration()));
            }
            if (this.getStateMachineName() != null) {
                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
            }
            if (this.getStateMachineType() != null) {
                data.set("stateMachineType", om.valueToTree(this.getStateMachineType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTracingConfiguration() != null) {
                data.set("tracingConfiguration", om.valueToTree(this.getTracingConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnStateMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStateMachineProps.Jsii$Proxy that = (CfnStateMachineProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.definitionS3Location != null ? !this.definitionS3Location.equals(that.definitionS3Location) : that.definitionS3Location != null) return false;
            if (this.definitionString != null ? !this.definitionString.equals(that.definitionString) : that.definitionString != null) return false;
            if (this.definitionSubstitutions != null ? !this.definitionSubstitutions.equals(that.definitionSubstitutions) : that.definitionSubstitutions != null) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.loggingConfiguration != null ? !this.loggingConfiguration.equals(that.loggingConfiguration) : that.loggingConfiguration != null) return false;
            if (this.stateMachineName != null ? !this.stateMachineName.equals(that.stateMachineName) : that.stateMachineName != null) return false;
            if (this.stateMachineType != null ? !this.stateMachineType.equals(that.stateMachineType) : that.stateMachineType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.tracingConfiguration != null ? this.tracingConfiguration.equals(that.tracingConfiguration) : that.tracingConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.definitionS3Location != null ? this.definitionS3Location.hashCode() : 0);
            result = 31 * result + (this.definitionString != null ? this.definitionString.hashCode() : 0);
            result = 31 * result + (this.definitionSubstitutions != null ? this.definitionSubstitutions.hashCode() : 0);
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.loggingConfiguration != null ? this.loggingConfiguration.hashCode() : 0);
            result = 31 * result + (this.stateMachineName != null ? this.stateMachineName.hashCode() : 0);
            result = 31 * result + (this.stateMachineType != null ? this.stateMachineType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tracingConfiguration != null ? this.tracingConfiguration.hashCode() : 0);
            return result;
        }
    }
}
