package software.amazon.awscdk.services.stepfunctions;

/**
 * Specifies the configuration for the processor Map state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * map.itemProcessor(new Pass(this, "Pass State"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.493Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ProcessorConfig")
@software.amazon.jsii.Jsii.Proxy(ProcessorConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProcessorConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the execution type for the Map workflow.
     * <p>
     * If you use the <code>Map</code> class, you must provide this field if you specified <code>DISTRIBUTED</code> for the <code>mode</code> sub-field.
     * <p>
     * If you use the <code>DistributedMap</code> class, this property is ignored.
     * Use the <code>mapExecutionType</code> in the <code>DistributedMap</code> class instead.
     * <p>
     * Default: - no execution type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorType getExecutionType() {
        return null;
    }

    /**
     * Specifies the execution mode for the Map workflow.
     * <p>
     * Default: - ProcessorMode.INLINE if using the `Map` class, ProcessorMode.DISTRIBUTED if using the `DistributedMap` class
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorMode getMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProcessorConfig> {
        software.amazon.awscdk.services.stepfunctions.ProcessorType executionType;
        software.amazon.awscdk.services.stepfunctions.ProcessorMode mode;

        /**
         * Sets the value of {@link ProcessorConfig#getExecutionType}
         * @param executionType Specifies the execution type for the Map workflow.
         *                      If you use the <code>Map</code> class, you must provide this field if you specified <code>DISTRIBUTED</code> for the <code>mode</code> sub-field.
         *                      <p>
         *                      If you use the <code>DistributedMap</code> class, this property is ignored.
         *                      Use the <code>mapExecutionType</code> in the <code>DistributedMap</code> class instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionType(software.amazon.awscdk.services.stepfunctions.ProcessorType executionType) {
            this.executionType = executionType;
            return this;
        }

        /**
         * Sets the value of {@link ProcessorConfig#getMode}
         * @param mode Specifies the execution mode for the Map workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(software.amazon.awscdk.services.stepfunctions.ProcessorMode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProcessorConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProcessorConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorConfig {
        private final software.amazon.awscdk.services.stepfunctions.ProcessorType executionType;
        private final software.amazon.awscdk.services.stepfunctions.ProcessorMode mode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionType = software.amazon.jsii.Kernel.get(this, "executionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProcessorType.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProcessorMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionType = builder.executionType;
            this.mode = builder.mode;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ProcessorType getExecutionType() {
            return this.executionType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ProcessorMode getMode() {
            return this.mode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExecutionType() != null) {
                data.set("executionType", om.valueToTree(this.getExecutionType()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ProcessorConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProcessorConfig.Jsii$Proxy that = (ProcessorConfig.Jsii$Proxy) o;

            if (this.executionType != null ? !this.executionType.equals(that.executionType) : that.executionType != null) return false;
            return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionType != null ? this.executionType.hashCode() : 0;
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            return result;
        }
    }
}
