package software.amazon.awscdk.services.stepfunctions;

/**
 * Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 * <p>
 * Default: FIRE_AND_FORGET
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectfully.">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectfully.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ServiceIntegrationPattern")
public enum ServiceIntegrationPattern {
    /**
     * Call a service and progress to the next state immediately after the API call completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIRE_AND_FORGET,
    /**
     * Call a service and wait for a job to complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYNC,
    /**
     * Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WAIT_FOR_TASK_TOKEN,
}
