package software.amazon.awscdk.services.stepfunctions;

/**
 * The transformation to be applied to the Output of the Child Workflow executions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * // create a WriterConfig
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriterV2(ResultWriterV2.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .writerConfig(Map.of(
 *                         "outputType", OutputType.JSONL,
 *                         "transformation", Transformation.NONE))
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:01.535Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Transformation")
public enum Transformation {
    /**
     * Returns the output of the child workflow executions unchanged, in addition to the workflow metadata.
     * <p>
     * Default when exporting the child workflow execution results to Amazon S3 and WriterConfig is not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * Returns the output of the child workflow executions.
     * <p>
     * Default when ResultWriter is not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPACT,
    /**
     * Returns the output of the child workflow executions.
     * <p>
     * If a child workflow execution returns an array,this option flattens the array,
     * prior to returning the result to a state output or writing the result to an Amazon S3 object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FLATTEN,
}
