package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The type of predefined worker that is allocated when a job runs.
 * <p>
 * If you need to use a WorkerTypeV2 that doesn't exist as a static member, you
 * can instantiate a <code>WorkerTypeV2</code> object, e.g: <code>WorkerTypeV2.of('other type')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GlueStartJobRun.Builder.create(this, "Task")
 *         .glueJobName("my-glue-job")
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .workerTypeV2(WorkerTypeV2.G_1X) // Worker type
 *                 .numberOfWorkers(2)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.047Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.WorkerTypeV2")
public class WorkerTypeV2 extends software.amazon.jsii.JsiiObject {

    protected WorkerTypeV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WorkerTypeV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        G_025_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "G_025X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        G_1_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "G_1X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        G_2_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "G_2X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        G_4_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "G_4X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        G_8_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "G_8X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        STANDARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "STANDARD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
        Z_2_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "Z_2X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class));
    }

    /**
     * Custom worker type.
     * <p>
     * @param workerType custom worker type. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 of(final @org.jetbrains.annotations.NotNull java.lang.String workerType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2.class), new Object[] { java.util.Objects.requireNonNull(workerType, "workerType is required") });
    }

    /**
     * Each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk), and provides 1 executor per worker. Suitable for low volume streaming jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 G_025_X;

    /**
     * Each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 G_1_X;

    /**
     * Each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 G_2_X;

    /**
     * Each worker maps to 4 DPU (16 vCPU, 64 GB of memory, 256 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 G_4_X;

    /**
     * Each worker maps to 8 DPU (32 vCPU, 128 GB of memory, 512 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 G_8_X;

    /**
     * Each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 STANDARD;

    /**
     * Each worker maps to 2 high-memory DPU [M-DPU] (8 vCPU, 64 GB of memory, 128 GB disk).
     * <p>
     * Supported in Ray jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.WorkerTypeV2 Z_2_X;

    /**
     * The name of this WorkerType, as expected by Job resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
