package software.amazon.awscdk.services.synthetics;

/**
 * Browser types supported by CloudWatch Synthetics Canary.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_9_1)
 *         .browserConfigs(List.of(BrowserType.CHROME, BrowserType.FIREFOX))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.060Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.BrowserType")
public enum BrowserType {
    /**
     * Google Chrome browser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CHROME,
    /**
     * Mozilla Firefox browser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIREFOX,
}
