package software.amazon.awscdk.services.synthetics;

/**
 * Creates or updates a canary.
 * <p>
 * Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.
 * <p>
 * Canaries are automated scripts that run at specified intervals against an endpoint. They include Python or Node.js code to create a Lambda function. This code needs to be packaged in a certain way, depending on the language. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html">Writing a canary script</a> .
 * <p>
 * To create canaries, you must have the <code>CloudWatchSyntheticsFullAccess</code> policy. If you are creating a new IAM role for the canary, you also need the the <code>iam:CreateRole</code> , <code>iam:CreatePolicy</code> and <code>iam:AttachRolePolicy</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles">Necessary Roles and Permissions</a> .
 * <p>
 * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.synthetics.*;
 * CfnCanary cfnCanary = CfnCanary.Builder.create(this, "MyCfnCanary")
 *         .artifactS3Location("artifactS3Location")
 *         .code(CodeProperty.builder()
 *                 .blueprintTypes(List.of("blueprintTypes"))
 *                 .dependencies(List.of(DependencyProperty.builder()
 *                         .reference("reference")
 *                         // the properties below are optional
 *                         .type("type")
 *                         .build()))
 *                 .handler("handler")
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .script("script")
 *                 .sourceLocationArn("sourceLocationArn")
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         .runtimeVersion("runtimeVersion")
 *         .schedule(ScheduleProperty.builder()
 *                 .expression("expression")
 *                 // the properties below are optional
 *                 .durationInSeconds("durationInSeconds")
 *                 .retryConfig(RetryConfigProperty.builder()
 *                         .maxRetries(123)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .artifactConfig(ArtifactConfigProperty.builder()
 *                 .s3Encryption(S3EncryptionProperty.builder()
 *                         .encryptionMode("encryptionMode")
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .build())
 *                 .build())
 *         .browserConfigs(List.of(BrowserConfigProperty.builder()
 *                 .browserType("browserType")
 *                 .build()))
 *         .deleteLambdaResourcesOnCanaryDeletion(false)
 *         .dryRunAndUpdate(false)
 *         .failureRetentionPeriod(123)
 *         .provisionedResourceCleanup("provisionedResourceCleanup")
 *         .resourcesToReplicateTags(List.of("resourcesToReplicateTags"))
 *         .runConfig(RunConfigProperty.builder()
 *                 .activeTracing(false)
 *                 .environmentVariables(Map.of(
 *                         "environmentVariablesKey", "environmentVariables"))
 *                 .ephemeralStorage(123)
 *                 .memoryInMb(123)
 *                 .timeoutInSeconds(123)
 *                 .build())
 *         .startCanaryAfterCreation(false)
 *         .successRetentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visualReference(VisualReferenceProperty.builder()
 *                 .baseCanaryRunId("baseCanaryRunId")
 *                 // the properties below are optional
 *                 .baseScreenshots(List.of(BaseScreenshotProperty.builder()
 *                         .screenshotName("screenshotName")
 *                         // the properties below are optional
 *                         .ignoreCoordinates(List.of("ignoreCoordinates"))
 *                         .build()))
 *                 .browserType("browserType")
 *                 .build())
 *         .visualReferences(List.of(VisualReferenceProperty.builder()
 *                 .baseCanaryRunId("baseCanaryRunId")
 *                 // the properties below are optional
 *                 .baseScreenshots(List.of(BaseScreenshotProperty.builder()
 *                         .screenshotName("screenshotName")
 *                         // the properties below are optional
 *                         .ignoreCoordinates(List.of("ignoreCoordinates"))
 *                         .build()))
 *                 .browserType("browserType")
 *                 .build()))
 *         .vpcConfig(VPCConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .ipv6AllowedForDualStack(false)
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.077Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary")
public class CfnCanary extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.synthetics.ICanaryRef, software.amazon.awscdk.ITaggable {

    protected CfnCanary(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCanary(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.CfnCanary.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Synthetics::Canary</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCanary(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanaryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new ICanaryRef from a canaryName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param canaryName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.synthetics.ICanaryRef fromCanaryName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String canaryName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.CfnCanary.class, "fromCanaryName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.synthetics.ICanaryRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(canaryName, "canaryName is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * <code>Ref</code> returns the ARN of the Lambda layer where Synthetics stores the canary script code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCodeSourceLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCodeSourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the canary.
     * <p>
     * For example, <code>RUNNING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A reference to a Canary resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.synthetics.CanaryReference getCanaryRef() {
        return software.amazon.jsii.Kernel.get(this, "canaryRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.synthetics.CanaryReference.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactS3Location() {
        return software.amazon.jsii.Kernel.get(this, "artifactS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactS3Location(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "artifactS3Location", java.util.Objects.requireNonNull(value, "artifactS3Location is required"));
    }

    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCode() {
        return software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this structure to input your script code for the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "code", java.util.Objects.requireNonNull(value, "code is required"));
    }

    /**
     * Use this structure to input your script code for the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty value) {
        software.amazon.jsii.Kernel.set(this, "code", java.util.Objects.requireNonNull(value, "code is required"));
    }

    /**
     * The ARN of the IAM role to be used to run the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role to be used to run the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", java.util.Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    /**
     * The name for this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Specifies the runtime version to use for the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuntimeVersion() {
        return software.amazon.jsii.Kernel.get(this, "runtimeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the runtime version to use for the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "runtimeVersion", java.util.Objects.requireNonNull(value, "runtimeVersion is required"));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactConfig() {
        return software.amazon.jsii.Kernel.get(this, "artifactConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactConfig", value);
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "artifactConfig", value);
    }

    /**
     * A structure that specifies the browser type to use for a canary run.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.BrowserConfigProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBrowserConfigs() {
        return software.amazon.jsii.Kernel.get(this, "browserConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that specifies the browser type to use for a canary run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrowserConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "browserConfigs", value);
    }

    /**
     * A structure that specifies the browser type to use for a canary run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrowserConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.synthetics.CfnCanary.BrowserConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.synthetics.CfnCanary.BrowserConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "browserConfigs", value);
    }

    /**
     * (deprecated) Deletes associated lambda resources created by Synthetics if set to True.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteLambdaResourcesOnCanaryDeletion() {
        return software.amazon.jsii.Kernel.get(this, "deleteLambdaResourcesOnCanaryDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (deprecated) Deletes associated lambda resources created by Synthetics if set to True.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setDeleteLambdaResourcesOnCanaryDeletion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteLambdaResourcesOnCanaryDeletion", value);
    }

    /**
     * (deprecated) Deletes associated lambda resources created by Synthetics if set to True.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setDeleteLambdaResourcesOnCanaryDeletion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteLambdaResourcesOnCanaryDeletion", value);
    }

    /**
     * Specifies whether to perform a dry run before updating the canary.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDryRunAndUpdate() {
        return software.amazon.jsii.Kernel.get(this, "dryRunAndUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to perform a dry run before updating the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDryRunAndUpdate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "dryRunAndUpdate", value);
    }

    /**
     * Specifies whether to perform a dry run before updating the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDryRunAndUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dryRunAndUpdate", value);
    }

    /**
     * The number of days to retain data about failed runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFailureRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "failureRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain data about failed runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailureRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "failureRetentionPeriod", value);
    }

    /**
     * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProvisionedResourceCleanup() {
        return software.amazon.jsii.Kernel.get(this, "provisionedResourceCleanup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedResourceCleanup(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provisionedResourceCleanup", value);
    }

    /**
     * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this property with the value <code>lambda-function</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesToReplicateTags() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourcesToReplicateTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this property with the value <code>lambda-function</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesToReplicateTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourcesToReplicateTags", value);
    }

    /**
     * A structure that contains input information for a canary run.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRunConfig() {
        return software.amazon.jsii.Kernel.get(this, "runConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains input information for a canary run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runConfig", value);
    }

    /**
     * A structure that contains input information for a canary run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "runConfig", value);
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStartCanaryAfterCreation() {
        return software.amazon.jsii.Kernel.get(this, "startCanaryAfterCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartCanaryAfterCreation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "startCanaryAfterCreation", value);
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartCanaryAfterCreation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "startCanaryAfterCreation", value);
    }

    /**
     * The number of days to retain data about successful runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSuccessRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "successRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain data about successful runs of this canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuccessRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "successRetentionPeriod", value);
    }

    /**
     * The list of key-value pairs that are associated with the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of key-value pairs that are associated with the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getVisualReference() {
        return software.amazon.jsii.Kernel.get(this, "visualReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setVisualReference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visualReference", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setVisualReference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "visualReference", value);
    }

    /**
     * A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVisualReferences() {
        return software.amazon.jsii.Kernel.get(this, "visualReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisualReferences(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visualReferences", value);
    }

    /**
     * A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisualReferences(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "visualReferences", value);
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * ArtifactConfigProperty artifactConfigProperty = ArtifactConfigProperty.builder()
     *         .s3Encryption(S3EncryptionProperty.builder()
     *                 .encryptionMode("encryptionMode")
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-artifactconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-artifactconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.ArtifactConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
         * <p>
         * Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.S3EncryptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-artifactconfig.html#cfn-synthetics-canary-artifactconfig-s3encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-artifactconfig.html#cfn-synthetics-canary-artifactconfig-s3encryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Encryption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactConfigProperty> {
            java.lang.Object s3Encryption;

            /**
             * Sets the value of {@link ArtifactConfigProperty#getS3Encryption}
             * @param s3Encryption A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
             *                     Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Encryption(software.amazon.awscdk.IResolvable s3Encryption) {
                this.s3Encryption = s3Encryption;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactConfigProperty#getS3Encryption}
             * @param s3Encryption A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
             *                     Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Encryption(software.amazon.awscdk.services.synthetics.CfnCanary.S3EncryptionProperty s3Encryption) {
                this.s3Encryption = s3Encryption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactConfigProperty {
            private final java.lang.Object s3Encryption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Encryption = software.amazon.jsii.Kernel.get(this, "s3Encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Encryption = builder.s3Encryption;
            }

            @Override
            public final java.lang.Object getS3Encryption() {
                return this.s3Encryption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Encryption() != null) {
                    data.set("s3Encryption", om.valueToTree(this.getS3Encryption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.ArtifactConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactConfigProperty.Jsii$Proxy that = (ArtifactConfigProperty.Jsii$Proxy) o;

                return this.s3Encryption != null ? this.s3Encryption.equals(that.s3Encryption) : that.s3Encryption == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Encryption != null ? this.s3Encryption.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A structure representing a screenshot that is used as a baseline during visual monitoring comparisons made by the canary.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * BaseScreenshotProperty baseScreenshotProperty = BaseScreenshotProperty.builder()
     *         .screenshotName("screenshotName")
     *         // the properties below are optional
     *         .ignoreCoordinates(List.of("ignoreCoordinates"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.BaseScreenshotProperty")
    @software.amazon.jsii.Jsii.Proxy(BaseScreenshotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaseScreenshotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the screenshot.
         * <p>
         * This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html#cfn-synthetics-canary-basescreenshot-screenshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html#cfn-synthetics-canary-basescreenshot-screenshotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScreenshotName();

        /**
         * Coordinates that define the part of a screen to ignore during screenshot comparisons.
         * <p>
         * To obtain the coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">Edit or delete a canary</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html#cfn-synthetics-canary-basescreenshot-ignorecoordinates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-basescreenshot.html#cfn-synthetics-canary-basescreenshot-ignorecoordinates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIgnoreCoordinates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaseScreenshotProperty> {
            java.lang.String screenshotName;
            java.util.List<java.lang.String> ignoreCoordinates;

            /**
             * Sets the value of {@link BaseScreenshotProperty#getScreenshotName}
             * @param screenshotName The name of the screenshot. This parameter is required.
             *                       This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder screenshotName(java.lang.String screenshotName) {
                this.screenshotName = screenshotName;
                return this;
            }

            /**
             * Sets the value of {@link BaseScreenshotProperty#getIgnoreCoordinates}
             * @param ignoreCoordinates Coordinates that define the part of a screen to ignore during screenshot comparisons.
             *                          To obtain the coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">Edit or delete a canary</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreCoordinates(java.util.List<java.lang.String> ignoreCoordinates) {
                this.ignoreCoordinates = ignoreCoordinates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaseScreenshotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaseScreenshotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseScreenshotProperty {
            private final java.lang.String screenshotName;
            private final java.util.List<java.lang.String> ignoreCoordinates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.screenshotName = software.amazon.jsii.Kernel.get(this, "screenshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ignoreCoordinates = software.amazon.jsii.Kernel.get(this, "ignoreCoordinates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.screenshotName = java.util.Objects.requireNonNull(builder.screenshotName, "screenshotName is required");
                this.ignoreCoordinates = builder.ignoreCoordinates;
            }

            @Override
            public final java.lang.String getScreenshotName() {
                return this.screenshotName;
            }

            @Override
            public final java.util.List<java.lang.String> getIgnoreCoordinates() {
                return this.ignoreCoordinates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("screenshotName", om.valueToTree(this.getScreenshotName()));
                if (this.getIgnoreCoordinates() != null) {
                    data.set("ignoreCoordinates", om.valueToTree(this.getIgnoreCoordinates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.BaseScreenshotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaseScreenshotProperty.Jsii$Proxy that = (BaseScreenshotProperty.Jsii$Proxy) o;

                if (!screenshotName.equals(that.screenshotName)) return false;
                return this.ignoreCoordinates != null ? this.ignoreCoordinates.equals(that.ignoreCoordinates) : that.ignoreCoordinates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.screenshotName.hashCode();
                result = 31 * result + (this.ignoreCoordinates != null ? this.ignoreCoordinates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that specifies the browser type to use for a canary run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * BrowserConfigProperty browserConfigProperty = BrowserConfigProperty.builder()
     *         .browserType("browserType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-browserconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-browserconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.BrowserConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BrowserConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BrowserConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The browser type associated with this browser configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-browserconfig.html#cfn-synthetics-canary-browserconfig-browsertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-browserconfig.html#cfn-synthetics-canary-browserconfig-browsertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBrowserType();

        /**
         * @return a {@link Builder} of {@link BrowserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BrowserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BrowserConfigProperty> {
            java.lang.String browserType;

            /**
             * Sets the value of {@link BrowserConfigProperty#getBrowserType}
             * @param browserType The browser type associated with this browser configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder browserType(java.lang.String browserType) {
                this.browserType = browserType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BrowserConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BrowserConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BrowserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BrowserConfigProperty {
            private final java.lang.String browserType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.browserType = software.amazon.jsii.Kernel.get(this, "browserType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.browserType = java.util.Objects.requireNonNull(builder.browserType, "browserType is required");
            }

            @Override
            public final java.lang.String getBrowserType() {
                return this.browserType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("browserType", om.valueToTree(this.getBrowserType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.BrowserConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BrowserConfigProperty.Jsii$Proxy that = (BrowserConfigProperty.Jsii$Proxy) o;

                return this.browserType.equals(that.browserType);
            }

            @Override
            public final int hashCode() {
                int result = this.browserType.hashCode();
                return result;
            }
        }
    }
    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * CodeProperty codeProperty = CodeProperty.builder()
     *         .blueprintTypes(List.of("blueprintTypes"))
     *         .dependencies(List.of(DependencyProperty.builder()
     *                 .reference("reference")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build()))
     *         .handler("handler")
     *         .s3Bucket("s3Bucket")
     *         .s3Key("s3Key")
     *         .s3ObjectVersion("s3ObjectVersion")
     *         .script("script")
     *         .sourceLocationArn("sourceLocationArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.CodeProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <code>BlueprintTypes</code> are a list of templates that enable simplified canary creation.
         * <p>
         * You can create canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing custom scripts. <code>multi-checks</code> is the only supported value.
         * <p>
         * When you specify <code>BlueprintTypes</code> , the <code>Handler</code> field cannot be specified since the blueprint provides a pre-defined entry point.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-blueprinttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-blueprinttypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBlueprintTypes() {
            return null;
        }

        /**
         * List of Lambda layers to attach to the canary.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.DependencyProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-dependencies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-dependencies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependencies() {
            return null;
        }

        /**
         * The entry point to use for the source code when running the canary.
         * <p>
         * For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code> , the handler must be specified as <code>*fileName* .handler</code> . For <code>syn-python-selenium-1.1</code> , <code>syn-nodejs.puppeteer-3.4</code> , and later runtimes, the handler can be specified as <code>*fileName* . *functionName*</code> , or you can specify a folder where canary scripts reside as <code>*folder* / *fileName* . *functionName*</code> .
         * <p>
         * This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you specify <code>BlueprintTypes</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-handler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-handler</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHandler() {
            return null;
        }

        /**
         * If your canary script is located in S3, specify the bucket name here.
         * <p>
         * The bucket must already exist.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Bucket() {
            return null;
        }

        /**
         * The Amazon S3 key of your script.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Key() {
            return null;
        }

        /**
         * The Amazon S3 version ID of your script.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3objectversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectVersion() {
            return null;
        }

        /**
         * If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text.
         * <p>
         * It can be up to 5 MB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-script">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-script</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScript() {
            return null;
        }

        /**
         * The ARN of the Lambda layer where Synthetics stores the canary script code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-sourcelocationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-sourcelocationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceLocationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeProperty> {
            java.util.List<java.lang.String> blueprintTypes;
            java.lang.Object dependencies;
            java.lang.String handler;
            java.lang.String s3Bucket;
            java.lang.String s3Key;
            java.lang.String s3ObjectVersion;
            java.lang.String script;
            java.lang.String sourceLocationArn;

            /**
             * Sets the value of {@link CodeProperty#getBlueprintTypes}
             * @param blueprintTypes <code>BlueprintTypes</code> are a list of templates that enable simplified canary creation.
             *                       You can create canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing custom scripts. <code>multi-checks</code> is the only supported value.
             *                       <p>
             *                       When you specify <code>BlueprintTypes</code> , the <code>Handler</code> field cannot be specified since the blueprint provides a pre-defined entry point.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprintTypes(java.util.List<java.lang.String> blueprintTypes) {
                this.blueprintTypes = blueprintTypes;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getDependencies}
             * @param dependencies List of Lambda layers to attach to the canary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencies(software.amazon.awscdk.IResolvable dependencies) {
                this.dependencies = dependencies;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getDependencies}
             * @param dependencies List of Lambda layers to attach to the canary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencies(java.util.List<? extends java.lang.Object> dependencies) {
                this.dependencies = dependencies;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getHandler}
             * @param handler The entry point to use for the source code when running the canary.
             *                For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code> , the handler must be specified as <code>*fileName* .handler</code> . For <code>syn-python-selenium-1.1</code> , <code>syn-nodejs.puppeteer-3.4</code> , and later runtimes, the handler can be specified as <code>*fileName* . *functionName*</code> , or you can specify a folder where canary scripts reside as <code>*folder* / *fileName* . *functionName*</code> .
             *                <p>
             *                This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you specify <code>BlueprintTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder handler(java.lang.String handler) {
                this.handler = handler;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3Bucket}
             * @param s3Bucket If your canary script is located in S3, specify the bucket name here.
             *                 The bucket must already exist.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3Key}
             * @param s3Key The Amazon S3 key of your script.
             *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3ObjectVersion}
             * @param s3ObjectVersion The Amazon S3 version ID of your script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectVersion(java.lang.String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getScript}
             * @param script If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text.
             *               It can be up to 5 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder script(java.lang.String script) {
                this.script = script;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getSourceLocationArn}
             * @param sourceLocationArn The ARN of the Lambda layer where Synthetics stores the canary script code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLocationArn(java.lang.String sourceLocationArn) {
                this.sourceLocationArn = sourceLocationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeProperty {
            private final java.util.List<java.lang.String> blueprintTypes;
            private final java.lang.Object dependencies;
            private final java.lang.String handler;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;
            private final java.lang.String s3ObjectVersion;
            private final java.lang.String script;
            private final java.lang.String sourceLocationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blueprintTypes = software.amazon.jsii.Kernel.get(this, "blueprintTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dependencies = software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectVersion = software.amazon.jsii.Kernel.get(this, "s3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceLocationArn = software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blueprintTypes = builder.blueprintTypes;
                this.dependencies = builder.dependencies;
                this.handler = builder.handler;
                this.s3Bucket = builder.s3Bucket;
                this.s3Key = builder.s3Key;
                this.s3ObjectVersion = builder.s3ObjectVersion;
                this.script = builder.script;
                this.sourceLocationArn = builder.sourceLocationArn;
            }

            @Override
            public final java.util.List<java.lang.String> getBlueprintTypes() {
                return this.blueprintTypes;
            }

            @Override
            public final java.lang.Object getDependencies() {
                return this.dependencies;
            }

            @Override
            public final java.lang.String getHandler() {
                return this.handler;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public final java.lang.String getS3ObjectVersion() {
                return this.s3ObjectVersion;
            }

            @Override
            public final java.lang.String getScript() {
                return this.script;
            }

            @Override
            public final java.lang.String getSourceLocationArn() {
                return this.sourceLocationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlueprintTypes() != null) {
                    data.set("blueprintTypes", om.valueToTree(this.getBlueprintTypes()));
                }
                if (this.getDependencies() != null) {
                    data.set("dependencies", om.valueToTree(this.getDependencies()));
                }
                if (this.getHandler() != null) {
                    data.set("handler", om.valueToTree(this.getHandler()));
                }
                if (this.getS3Bucket() != null) {
                    data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                }
                if (this.getS3Key() != null) {
                    data.set("s3Key", om.valueToTree(this.getS3Key()));
                }
                if (this.getS3ObjectVersion() != null) {
                    data.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                }
                if (this.getScript() != null) {
                    data.set("script", om.valueToTree(this.getScript()));
                }
                if (this.getSourceLocationArn() != null) {
                    data.set("sourceLocationArn", om.valueToTree(this.getSourceLocationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.CodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeProperty.Jsii$Proxy that = (CodeProperty.Jsii$Proxy) o;

                if (this.blueprintTypes != null ? !this.blueprintTypes.equals(that.blueprintTypes) : that.blueprintTypes != null) return false;
                if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) return false;
                if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) return false;
                if (this.s3Bucket != null ? !this.s3Bucket.equals(that.s3Bucket) : that.s3Bucket != null) return false;
                if (this.s3Key != null ? !this.s3Key.equals(that.s3Key) : that.s3Key != null) return false;
                if (this.s3ObjectVersion != null ? !this.s3ObjectVersion.equals(that.s3ObjectVersion) : that.s3ObjectVersion != null) return false;
                if (this.script != null ? !this.script.equals(that.script) : that.script != null) return false;
                return this.sourceLocationArn != null ? this.sourceLocationArn.equals(that.sourceLocationArn) : that.sourceLocationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blueprintTypes != null ? this.blueprintTypes.hashCode() : 0;
                result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
                result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
                result = 31 * result + (this.s3Bucket != null ? this.s3Bucket.hashCode() : 0);
                result = 31 * result + (this.s3Key != null ? this.s3Key.hashCode() : 0);
                result = 31 * result + (this.s3ObjectVersion != null ? this.s3ObjectVersion.hashCode() : 0);
                result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
                result = 31 * result + (this.sourceLocationArn != null ? this.sourceLocationArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains information about a dependency for a canary.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * DependencyProperty dependencyProperty = DependencyProperty.builder()
     *         .reference("reference")
     *         // the properties below are optional
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.DependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(DependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dependency reference.
         * <p>
         * For Lambda layers, this is the ARN of the Lambda layer. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html#cfn-synthetics-canary-dependency-reference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html#cfn-synthetics-canary-dependency-reference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReference();

        /**
         * The type of dependency.
         * <p>
         * Valid value is <code>LambdaLayer</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html#cfn-synthetics-canary-dependency-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-dependency.html#cfn-synthetics-canary-dependency-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DependencyProperty> {
            java.lang.String reference;
            java.lang.String type;

            /**
             * Sets the value of {@link DependencyProperty#getReference}
             * @param reference The dependency reference. This parameter is required.
             *                  For Lambda layers, this is the ARN of the Lambda layer. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reference(java.lang.String reference) {
                this.reference = reference;
                return this;
            }

            /**
             * Sets the value of {@link DependencyProperty#getType}
             * @param type The type of dependency.
             *             Valid value is <code>LambdaLayer</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DependencyProperty {
            private final java.lang.String reference;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reference = software.amazon.jsii.Kernel.get(this, "reference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reference = java.util.Objects.requireNonNull(builder.reference, "reference is required");
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getReference() {
                return this.reference;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("reference", om.valueToTree(this.getReference()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.DependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DependencyProperty.Jsii$Proxy that = (DependencyProperty.Jsii$Proxy) o;

                if (!reference.equals(that.reference)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reference.hashCode();
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The canary's retry configuration information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * RetryConfigProperty retryConfigProperty = RetryConfigProperty.builder()
     *         .maxRetries(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-retryconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-retryconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.RetryConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of retries.
         * <p>
         * The value must be less than or equal to two.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-retryconfig.html#cfn-synthetics-canary-retryconfig-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-retryconfig.html#cfn-synthetics-canary-retryconfig-maxretries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetries();

        /**
         * @return a {@link Builder} of {@link RetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryConfigProperty> {
            java.lang.Number maxRetries;

            /**
             * Sets the value of {@link RetryConfigProperty#getMaxRetries}
             * @param maxRetries The maximum number of retries. This parameter is required.
             *                   The value must be less than or equal to two.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetries(java.lang.Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryConfigProperty {
            private final java.lang.Number maxRetries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRetries = java.util.Objects.requireNonNull(builder.maxRetries, "maxRetries is required");
            }

            @Override
            public final java.lang.Number getMaxRetries() {
                return this.maxRetries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.RetryConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryConfigProperty.Jsii$Proxy that = (RetryConfigProperty.Jsii$Proxy) o;

                return this.maxRetries.equals(that.maxRetries);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRetries.hashCode();
                return result;
            }
        }
    }
    /**
     * A structure that contains input information for a canary run.
     * <p>
     * This structure is required.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * RunConfigProperty runConfigProperty = RunConfigProperty.builder()
     *         .activeTracing(false)
     *         .environmentVariables(Map.of(
     *                 "environmentVariablesKey", "environmentVariables"))
     *         .ephemeralStorage(123)
     *         .memoryInMb(123)
     *         .timeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.RunConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RunConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
         * <p>
         * Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
         * <p>
         * You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-activetracing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-activetracing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActiveTracing() {
            return null;
        }

        /**
         * Specifies the keys and values to use for any environment variables used in the canary script.
         * <p>
         * Use the following format:
         * <p>
         * { "key1" : "value1", "key2" : "value2", ...}
         * <p>
         * Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-environmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution.
         * <p>
         * This temporary storage is used for storing canary run artifacts (which are uploaded to an Amazon S3 bucket at the end of the run), and any canary browser operations. This temporary storage is cleared after the run is completed. Default storage value is 1024 MB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-ephemeralstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEphemeralStorage() {
            return null;
        }

        /**
         * The maximum amount of memory that the canary can use while running.
         * <p>
         * This value must be a multiple of 64. The range is 960 to 3008.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-memoryinmb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-memoryinmb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryInMb() {
            return null;
        }

        /**
         * How long the canary is allowed to run before it must stop.
         * <p>
         * You can't set this time to be longer than the frequency of the runs of this canary.
         * <p>
         * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 900 seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-timeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunConfigProperty> {
            java.lang.Object activeTracing;
            java.lang.Object environmentVariables;
            java.lang.Number ephemeralStorage;
            java.lang.Number memoryInMb;
            java.lang.Number timeoutInSeconds;

            /**
             * Sets the value of {@link RunConfigProperty#getActiveTracing}
             * @param activeTracing Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
             *                      Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
             *                      <p>
             *                      You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeTracing(java.lang.Boolean activeTracing) {
                this.activeTracing = activeTracing;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getActiveTracing}
             * @param activeTracing Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
             *                      Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
             *                      <p>
             *                      You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeTracing(software.amazon.awscdk.IResolvable activeTracing) {
                this.activeTracing = activeTracing;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getEnvironmentVariables}
             * @param environmentVariables Specifies the keys and values to use for any environment variables used in the canary script.
             *                             Use the following format:
             *                             <p>
             *                             { "key1" : "value1", "key2" : "value2", ...}
             *                             <p>
             *                             Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getEnvironmentVariables}
             * @param environmentVariables Specifies the keys and values to use for any environment variables used in the canary script.
             *                             Use the following format:
             *                             <p>
             *                             { "key1" : "value1", "key2" : "value2", ...}
             *                             <p>
             *                             Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getEphemeralStorage}
             * @param ephemeralStorage Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution.
             *                         This temporary storage is used for storing canary run artifacts (which are uploaded to an Amazon S3 bucket at the end of the run), and any canary browser operations. This temporary storage is cleared after the run is completed. Default storage value is 1024 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(java.lang.Number ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getMemoryInMb}
             * @param memoryInMb The maximum amount of memory that the canary can use while running.
             *                   This value must be a multiple of 64. The range is 960 to 3008.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryInMb(java.lang.Number memoryInMb) {
                this.memoryInMb = memoryInMb;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds How long the canary is allowed to run before it must stop.
             *                         You can't set this time to be longer than the frequency of the runs of this canary.
             *                         <p>
             *                         If you omit this field, the frequency of the canary is used as this value, up to a maximum of 900 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunConfigProperty {
            private final java.lang.Object activeTracing;
            private final java.lang.Object environmentVariables;
            private final java.lang.Number ephemeralStorage;
            private final java.lang.Number memoryInMb;
            private final java.lang.Number timeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activeTracing = software.amazon.jsii.Kernel.get(this, "activeTracing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryInMb = software.amazon.jsii.Kernel.get(this, "memoryInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activeTracing = builder.activeTracing;
                this.environmentVariables = builder.environmentVariables;
                this.ephemeralStorage = builder.ephemeralStorage;
                this.memoryInMb = builder.memoryInMb;
                this.timeoutInSeconds = builder.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getActiveTracing() {
                return this.activeTracing;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.Number getEphemeralStorage() {
                return this.ephemeralStorage;
            }

            @Override
            public final java.lang.Number getMemoryInMb() {
                return this.memoryInMb;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActiveTracing() != null) {
                    data.set("activeTracing", om.valueToTree(this.getActiveTracing()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getEphemeralStorage() != null) {
                    data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
                }
                if (this.getMemoryInMb() != null) {
                    data.set("memoryInMb", om.valueToTree(this.getMemoryInMb()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.RunConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunConfigProperty.Jsii$Proxy that = (RunConfigProperty.Jsii$Proxy) o;

                if (this.activeTracing != null ? !this.activeTracing.equals(that.activeTracing) : that.activeTracing != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
                if (this.memoryInMb != null ? !this.memoryInMb.equals(that.memoryInMb) : that.memoryInMb != null) return false;
                return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activeTracing != null ? this.activeTracing.hashCode() : 0;
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
                result = 31 * result + (this.memoryInMb != null ? this.memoryInMb.hashCode() : 0);
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
     * <p>
     * Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * S3EncryptionProperty s3EncryptionProperty = S3EncryptionProperty.builder()
     *         .encryptionMode("encryptionMode")
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.S3EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(S3EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption method to use for artifacts created by this canary.
         * <p>
         * Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed AWS KMS key.
         * <p>
         * If you omit this parameter, an AWS -managed AWS KMS key is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html#cfn-synthetics-canary-s3encryption-encryptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html#cfn-synthetics-canary-s3encryption-encryptionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
            return null;
        }

        /**
         * The ARN of the customer-managed AWS KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html#cfn-synthetics-canary-s3encryption-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-s3encryption.html#cfn-synthetics-canary-s3encryption-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3EncryptionProperty> {
            java.lang.String encryptionMode;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3EncryptionProperty#getEncryptionMode}
             * @param encryptionMode The encryption method to use for artifacts created by this canary.
             *                       Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed AWS KMS key.
             *                       <p>
             *                       If you omit this parameter, an AWS -managed AWS KMS key is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMode(java.lang.String encryptionMode) {
                this.encryptionMode = encryptionMode;
                return this;
            }

            /**
             * Sets the value of {@link S3EncryptionProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the customer-managed AWS KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EncryptionProperty {
            private final java.lang.String encryptionMode;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionMode = software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionMode = builder.encryptionMode;
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getEncryptionMode() {
                return this.encryptionMode;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryptionMode() != null) {
                    data.set("encryptionMode", om.valueToTree(this.getEncryptionMode()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.S3EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3EncryptionProperty.Jsii$Proxy that = (S3EncryptionProperty.Jsii$Proxy) o;

                if (this.encryptionMode != null ? !this.encryptionMode.equals(that.encryptionMode) : that.encryptionMode != null) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionMode != null ? this.encryptionMode.hashCode() : 0;
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies how often a canary is to make runs and the date and time when it should stop making runs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .expression("expression")
     *         // the properties below are optional
     *         .durationInSeconds("durationInSeconds")
     *         .retryConfig(RetryConfigProperty.builder()
     *                 .maxRetries(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.
         * <p>
         * For a rate expression, The syntax is <code>rate( *number unit* )</code> . <em>unit</em> can be <code>minute</code> , <code>minutes</code> , or <code>hour</code> .
         * <p>
         * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code> .
         * <p>
         * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.
         * <p>
         * Use <code>cron( *expression* )</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">Scheduling canary runs using cron</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value.
         * <p>
         * If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDurationInSeconds() {
            return null;
        }

        /**
         * The canary's retry configuration information.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.RetryConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-retryconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-retryconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String expression;
            java.lang.String durationInSeconds;
            java.lang.Object retryConfig;

            /**
             * Sets the value of {@link ScheduleProperty#getExpression}
             * @param expression A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run. This parameter is required.
             *                   For a rate expression, The syntax is <code>rate( *number unit* )</code> . <em>unit</em> can be <code>minute</code> , <code>minutes</code> , or <code>hour</code> .
             *                   <p>
             *                   For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code> .
             *                   <p>
             *                   Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.
             *                   <p>
             *                   Use <code>cron( *expression* )</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">Scheduling canary runs using cron</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDurationInSeconds}
             * @param durationInSeconds How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value.
             *                          If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.String durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetryConfig}
             * @param retryConfig The canary's retry configuration information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryConfig(software.amazon.awscdk.IResolvable retryConfig) {
                this.retryConfig = retryConfig;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetryConfig}
             * @param retryConfig The canary's retry configuration information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryConfig(software.amazon.awscdk.services.synthetics.CfnCanary.RetryConfigProperty retryConfig) {
                this.retryConfig = retryConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String expression;
            private final java.lang.String durationInSeconds;
            private final java.lang.Object retryConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retryConfig = software.amazon.jsii.Kernel.get(this, "retryConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.durationInSeconds = builder.durationInSeconds;
                this.retryConfig = builder.retryConfig;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            public final java.lang.Object getRetryConfig() {
                return this.retryConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }
                if (this.getRetryConfig() != null) {
                    data.set("retryConfig", om.valueToTree(this.getRetryConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (this.durationInSeconds != null ? !this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds != null) return false;
                return this.retryConfig != null ? this.retryConfig.equals(that.retryConfig) : that.retryConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0);
                result = 31 * result + (this.retryConfig != null ? this.retryConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * VPCConfigProperty vPCConfigProperty = VPCConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         // the properties below are optional
     *         .ipv6AllowedForDualStack(false)
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.VPCConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the security groups for this canary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The IDs of the subnets where this canary is to run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * Set this to <code>true</code> to allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-ipv6allowedfordualstack">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-ipv6allowedfordualstack</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6AllowedForDualStack() {
            return null;
        }

        /**
         * The ID of the VPC where this canary is to run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-vpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;
            java.lang.Object ipv6AllowedForDualStack;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VPCConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The IDs of the security groups for this canary. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getSubnetIds}
             * @param subnetIds The IDs of the subnets where this canary is to run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getIpv6AllowedForDualStack}
             * @param ipv6AllowedForDualStack Set this to <code>true</code> to allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets.
             *                                The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AllowedForDualStack(java.lang.Boolean ipv6AllowedForDualStack) {
                this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getIpv6AllowedForDualStack}
             * @param ipv6AllowedForDualStack Set this to <code>true</code> to allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets.
             *                                The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AllowedForDualStack(software.amazon.awscdk.IResolvable ipv6AllowedForDualStack) {
                this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getVpcId}
             * @param vpcId The ID of the VPC where this canary is to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.Object ipv6AllowedForDualStack;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipv6AllowedForDualStack = software.amazon.jsii.Kernel.get(this, "ipv6AllowedForDualStack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
                this.ipv6AllowedForDualStack = builder.ipv6AllowedForDualStack;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.Object getIpv6AllowedForDualStack() {
                return this.ipv6AllowedForDualStack;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                if (this.getIpv6AllowedForDualStack() != null) {
                    data.set("ipv6AllowedForDualStack", om.valueToTree(this.getIpv6AllowedForDualStack()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.VPCConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCConfigProperty.Jsii$Proxy that = (VPCConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                if (!subnetIds.equals(that.subnetIds)) return false;
                if (this.ipv6AllowedForDualStack != null ? !this.ipv6AllowedForDualStack.equals(that.ipv6AllowedForDualStack) : that.ipv6AllowedForDualStack != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                result = 31 * result + (this.ipv6AllowedForDualStack != null ? this.ipv6AllowedForDualStack.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary.
     * <p>
     * If you omit this parameter, no changes are made to any baseline screenshots that the canary might be using already.
     * <p>
     * Visual monitoring is supported only on canaries running the <em>syn-puppeteer-node-3.2</em> runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">Visual monitoring blueprint</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * VisualReferenceProperty visualReferenceProperty = VisualReferenceProperty.builder()
     *         .baseCanaryRunId("baseCanaryRunId")
     *         // the properties below are optional
     *         .baseScreenshots(List.of(BaseScreenshotProperty.builder()
     *                 .screenshotName("screenshotName")
     *                 // the properties below are optional
     *                 .ignoreCoordinates(List.of("ignoreCoordinates"))
     *                 .build()))
     *         .browserType("browserType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanary.VisualReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(VisualReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VisualReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary.
         * <p>
         * Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html">CanaryRun</a> from any past run of this canary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-basecanaryrunid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-basecanaryrunid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBaseCanaryRunId();

        /**
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.synthetics.CfnCanary.BaseScreenshotProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-basescreenshots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-basescreenshots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaseScreenshots() {
            return null;
        }

        /**
         * The browser type associated with this visual reference configuration.
         * <p>
         * Valid values are <code>CHROME</code> and <code>FIREFOX</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-browsertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-visualreference.html#cfn-synthetics-canary-visualreference-browsertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBrowserType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VisualReferenceProperty> {
            java.lang.String baseCanaryRunId;
            java.lang.Object baseScreenshots;
            java.lang.String browserType;

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseCanaryRunId}
             * @param baseCanaryRunId Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. This parameter is required.
             *                        Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html">CanaryRun</a> from any past run of this canary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseCanaryRunId(java.lang.String baseCanaryRunId) {
                this.baseCanaryRunId = baseCanaryRunId;
                return this;
            }

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseScreenshots}
             * @param baseScreenshots An array of screenshots that are used as the baseline for comparisons during visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseScreenshots(software.amazon.awscdk.IResolvable baseScreenshots) {
                this.baseScreenshots = baseScreenshots;
                return this;
            }

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseScreenshots}
             * @param baseScreenshots An array of screenshots that are used as the baseline for comparisons during visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseScreenshots(java.util.List<? extends java.lang.Object> baseScreenshots) {
                this.baseScreenshots = baseScreenshots;
                return this;
            }

            /**
             * Sets the value of {@link VisualReferenceProperty#getBrowserType}
             * @param browserType The browser type associated with this visual reference configuration.
             *                    Valid values are <code>CHROME</code> and <code>FIREFOX</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder browserType(java.lang.String browserType) {
                this.browserType = browserType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VisualReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VisualReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VisualReferenceProperty {
            private final java.lang.String baseCanaryRunId;
            private final java.lang.Object baseScreenshots;
            private final java.lang.String browserType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseCanaryRunId = software.amazon.jsii.Kernel.get(this, "baseCanaryRunId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baseScreenshots = software.amazon.jsii.Kernel.get(this, "baseScreenshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.browserType = software.amazon.jsii.Kernel.get(this, "browserType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseCanaryRunId = java.util.Objects.requireNonNull(builder.baseCanaryRunId, "baseCanaryRunId is required");
                this.baseScreenshots = builder.baseScreenshots;
                this.browserType = builder.browserType;
            }

            @Override
            public final java.lang.String getBaseCanaryRunId() {
                return this.baseCanaryRunId;
            }

            @Override
            public final java.lang.Object getBaseScreenshots() {
                return this.baseScreenshots;
            }

            @Override
            public final java.lang.String getBrowserType() {
                return this.browserType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseCanaryRunId", om.valueToTree(this.getBaseCanaryRunId()));
                if (this.getBaseScreenshots() != null) {
                    data.set("baseScreenshots", om.valueToTree(this.getBaseScreenshots()));
                }
                if (this.getBrowserType() != null) {
                    data.set("browserType", om.valueToTree(this.getBrowserType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanary.VisualReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VisualReferenceProperty.Jsii$Proxy that = (VisualReferenceProperty.Jsii$Proxy) o;

                if (!baseCanaryRunId.equals(that.baseCanaryRunId)) return false;
                if (this.baseScreenshots != null ? !this.baseScreenshots.equals(that.baseScreenshots) : that.baseScreenshots != null) return false;
                return this.browserType != null ? this.browserType.equals(that.browserType) : that.browserType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseCanaryRunId.hashCode();
                result = 31 * result + (this.baseScreenshots != null ? this.baseScreenshots.hashCode() : 0);
                result = 31 * result + (this.browserType != null ? this.browserType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.synthetics.CfnCanary}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.synthetics.CfnCanary> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.synthetics.CfnCanaryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.synthetics.CfnCanaryProps.Builder();
        }

        /**
         * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
         * <p>
         * Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location</a>
         * @param artifactS3Location The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactS3Location(final java.lang.String artifactS3Location) {
            this.props.artifactS3Location(artifactS3Location);
            return this;
        }

        /**
         * Use this structure to input your script code for the canary.
         * <p>
         * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code</a>
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.IResolvable code) {
            this.props.code(code);
            return this;
        }
        /**
         * Use this structure to input your script code for the canary.
         * <p>
         * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code</a>
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty code) {
            this.props.code(code);
            return this;
        }

        /**
         * The ARN of the IAM role to be used to run the canary.
         * <p>
         * This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
         * <p>
         * <ul>
         * <li><code>s3:PutObject</code></li>
         * <li><code>s3:GetBucketLocation</code></li>
         * <li><code>s3:ListAllMyBuckets</code></li>
         * <li><code>cloudwatch:PutMetricData</code></li>
         * <li><code>logs:CreateLogGroup</code></li>
         * <li><code>logs:CreateLogStream</code></li>
         * <li><code>logs:PutLogEvents</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn</a>
         * @param executionRoleArn The ARN of the IAM role to be used to run the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The name for this canary.
         * <p>
         * Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
         * <p>
         * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name</a>
         * @param name The name for this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies the runtime version to use for the canary.
         * <p>
         * For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion</a>
         * @param runtimeVersion Specifies the runtime version to use for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeVersion(final java.lang.String runtimeVersion) {
            this.props.runtimeVersion(runtimeVersion);
            return this;
        }

        /**
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule</a>
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule</a>
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifactconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifactconfig</a>
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(final software.amazon.awscdk.IResolvable artifactConfig) {
            this.props.artifactConfig(artifactConfig);
            return this;
        }
        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifactconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifactconfig</a>
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty artifactConfig) {
            this.props.artifactConfig(artifactConfig);
            return this;
        }

        /**
         * A structure that specifies the browser type to use for a canary run.
         * <p>
         * CloudWatch Synthetics supports running canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
         * <p>
         * <blockquote>
         * <p>
         * If not specified, <code>browserConfigs</code> defaults to Chrome.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-browserconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-browserconfigs</a>
         * @param browserConfigs A structure that specifies the browser type to use for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserConfigs(final software.amazon.awscdk.IResolvable browserConfigs) {
            this.props.browserConfigs(browserConfigs);
            return this;
        }
        /**
         * A structure that specifies the browser type to use for a canary run.
         * <p>
         * CloudWatch Synthetics supports running canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
         * <p>
         * <blockquote>
         * <p>
         * If not specified, <code>browserConfigs</code> defaults to Chrome.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-browserconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-browserconfigs</a>
         * @param browserConfigs A structure that specifies the browser type to use for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserConfigs(final java.util.List<? extends java.lang.Object> browserConfigs) {
            this.props.browserConfigs(browserConfigs);
            return this;
        }

        /**
         * (deprecated) Deletes associated lambda resources created by Synthetics if set to True.
         * <p>
         * Default is False
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-deletelambdaresourcesoncanarydeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-deletelambdaresourcesoncanarydeletion</a>
         * @deprecated this property has been deprecated
         * @param deleteLambdaResourcesOnCanaryDeletion Deletes associated lambda resources created by Synthetics if set to True. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder deleteLambdaResourcesOnCanaryDeletion(final java.lang.Boolean deleteLambdaResourcesOnCanaryDeletion) {
            this.props.deleteLambdaResourcesOnCanaryDeletion(deleteLambdaResourcesOnCanaryDeletion);
            return this;
        }
        /**
         * (deprecated) Deletes associated lambda resources created by Synthetics if set to True.
         * <p>
         * Default is False
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-deletelambdaresourcesoncanarydeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-deletelambdaresourcesoncanarydeletion</a>
         * @deprecated this property has been deprecated
         * @param deleteLambdaResourcesOnCanaryDeletion Deletes associated lambda resources created by Synthetics if set to True. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder deleteLambdaResourcesOnCanaryDeletion(final software.amazon.awscdk.IResolvable deleteLambdaResourcesOnCanaryDeletion) {
            this.props.deleteLambdaResourcesOnCanaryDeletion(deleteLambdaResourcesOnCanaryDeletion);
            return this;
        }

        /**
         * Specifies whether to perform a dry run before updating the canary.
         * <p>
         * If set to <code>true</code> , CloudFormation will execute a dry run to validate the changes before applying them to the canary. If the dry run succeeds, the canary will be updated with the changes. If the dry run fails, the CloudFormation deployment will fail with the dry run’s failure reason.
         * <p>
         * If set to <code>false</code> or omitted, the canary will be updated directly without first performing a dry run. The default value is <code>false</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/performing-safe-canary-upgrades.html">Performing safe canary updates</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-dryrunandupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-dryrunandupdate</a>
         * @param dryRunAndUpdate Specifies whether to perform a dry run before updating the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dryRunAndUpdate(final java.lang.Boolean dryRunAndUpdate) {
            this.props.dryRunAndUpdate(dryRunAndUpdate);
            return this;
        }
        /**
         * Specifies whether to perform a dry run before updating the canary.
         * <p>
         * If set to <code>true</code> , CloudFormation will execute a dry run to validate the changes before applying them to the canary. If the dry run succeeds, the canary will be updated with the changes. If the dry run fails, the CloudFormation deployment will fail with the dry run’s failure reason.
         * <p>
         * If set to <code>false</code> or omitted, the canary will be updated directly without first performing a dry run. The default value is <code>false</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/performing-safe-canary-upgrades.html">Performing safe canary updates</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-dryrunandupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-dryrunandupdate</a>
         * @param dryRunAndUpdate Specifies whether to perform a dry run before updating the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dryRunAndUpdate(final software.amazon.awscdk.IResolvable dryRunAndUpdate) {
            this.props.dryRunAndUpdate(dryRunAndUpdate);
            return this;
        }

        /**
         * The number of days to retain data about failed runs of this canary.
         * <p>
         * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * <p>
         * This setting affects the range of information returned by <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html">GetCanaryRuns</a> , as well as the range of information displayed in the Synthetics console.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod</a>
         * @param failureRetentionPeriod The number of days to retain data about failed runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureRetentionPeriod(final java.lang.Number failureRetentionPeriod) {
            this.props.failureRetentionPeriod(failureRetentionPeriod);
            return this;
        }

        /**
         * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
         * <p>
         * If it is <code>AUTOMATIC</code> , the Lambda functions and layers will be deleted when the canary is deleted.
         * <p>
         * If the value of this parameter is <code>OFF</code> , then the value of the <code>DeleteLambda</code> parameter of the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html">DeleteCanary</a> operation determines whether the Lambda functions and layers will be deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-provisionedresourcecleanup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-provisionedresourcecleanup</a>
         * @param provisionedResourceCleanup Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedResourceCleanup(final java.lang.String provisionedResourceCleanup) {
            this.props.provisionedResourceCleanup(provisionedResourceCleanup);
            return this;
        }

        /**
         * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this property with the value <code>lambda-function</code> .
         * <p>
         * If you do this, CloudWatch Synthetics will keep the tags of the canary and the Lambda function synchronized. Any future changes you make to the canary's tags will also be applied to the function.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-resourcestoreplicatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-resourcestoreplicatetags</a>
         * @param resourcesToReplicateTags To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this property with the value <code>lambda-function</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesToReplicateTags(final java.util.List<java.lang.String> resourcesToReplicateTags) {
            this.props.resourcesToReplicateTags(resourcesToReplicateTags);
            return this;
        }

        /**
         * A structure that contains input information for a canary run.
         * <p>
         * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig</a>
         * @param runConfig A structure that contains input information for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(final software.amazon.awscdk.IResolvable runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }
        /**
         * A structure that contains input information for a canary run.
         * <p>
         * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig</a>
         * @param runConfig A structure that contains input information for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }

        /**
         * Specify TRUE to have the canary start making runs immediately after it is created.
         * <p>
         * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation</a>
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(final java.lang.Boolean startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }
        /**
         * Specify TRUE to have the canary start making runs immediately after it is created.
         * <p>
         * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation</a>
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(final software.amazon.awscdk.IResolvable startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }

        /**
         * The number of days to retain data about successful runs of this canary.
         * <p>
         * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * <p>
         * This setting affects the range of information returned by <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html">GetCanaryRuns</a> , as well as the range of information displayed in the Synthetics console.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod</a>
         * @param successRetentionPeriod The number of days to retain data about successful runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successRetentionPeriod(final java.lang.Number successRetentionPeriod) {
            this.props.successRetentionPeriod(successRetentionPeriod);
            return this;
        }

        /**
         * The list of key-value pairs that are associated with the canary.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags</a>
         * @param tags The list of key-value pairs that are associated with the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreference</a>
         * @deprecated this property has been deprecated
         * @param visualReference This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder visualReference(final software.amazon.awscdk.IResolvable visualReference) {
            this.props.visualReference(visualReference);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreference</a>
         * @deprecated this property has been deprecated
         * @param visualReference This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder visualReference(final software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty visualReference) {
            this.props.visualReference(visualReference);
            return this;
        }

        /**
         * A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on.
         * <p>
         * Visual references are used for visual monitoring comparisons.
         * <p>
         * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only supports <code>visualReferences</code> . <code>visualReference</code> field is not supported.
         * <p>
         * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and <code>visualReferences</code> for backward compatibility. It is recommended to use <code>visualReferences</code> for consistency and future compatibility.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreferences</a>
         * @param visualReferences A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReferences(final software.amazon.awscdk.IResolvable visualReferences) {
            this.props.visualReferences(visualReferences);
            return this;
        }
        /**
         * A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on.
         * <p>
         * Visual references are used for visual monitoring comparisons.
         * <p>
         * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only supports <code>visualReferences</code> . <code>visualReference</code> field is not supported.
         * <p>
         * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and <code>visualReferences</code> for backward compatibility. It is recommended to use <code>visualReferences</code> for consistency and future compatibility.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-visualreferences</a>
         * @param visualReferences A list of visual reference configurations for the canary, one for each browser type that the canary is configured to run on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReferences(final java.util.List<? extends java.lang.Object> visualReferences) {
            this.props.visualReferences(visualReferences);
            return this;
        }

        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig</a>
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig</a>
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.synthetics.CfnCanary}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.synthetics.CfnCanary build() {
            return new software.amazon.awscdk.services.synthetics.CfnCanary(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
