package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a <code>CfnConnector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * Object as2Config;
 * CfnConnectorProps cfnConnectorProps = CfnConnectorProps.builder()
 *         .accessRole("accessRole")
 *         // the properties below are optional
 *         .as2Config(as2Config)
 *         .egressConfig(ConnectorEgressConfigProperty.builder()
 *                 .vpcLattice(ConnectorVpcLatticeEgressConfigProperty.builder()
 *                         .resourceConfigurationArn("resourceConfigurationArn")
 *                         // the properties below are optional
 *                         .portNumber(123)
 *                         .build())
 *                 .build())
 *         .egressType("egressType")
 *         .loggingRole("loggingRole")
 *         .securityPolicyName("securityPolicyName")
 *         .sftpConfig(SftpConfigProperty.builder()
 *                 .maxConcurrentConnections(123)
 *                 .trustedHostKeys(List.of("trustedHostKeys"))
 *                 .userSecretId("userSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .url("url")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnConnectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     * <p>
     * For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
     * <p>
     * <em>For AS2 connectors</em>
     * <p>
     * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
     * <p>
     * If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
     * <p>
     * <em>For SFTP connectors</em>
     * <p>
     * Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-accessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-accessrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessRole();

    /**
     * A structure that contains the parameters for an AS2 connector object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-as2config">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-as2config</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAs2Config() {
        return null;
    }

    /**
     * Current egress configuration of the connector, showing how traffic is routed to the SFTP server.
     * <p>
     * Contains VPC Lattice settings when using VPC_LATTICE egress type.
     * <p>
     * When using the VPC_LATTICE egress type, AWS Transfer Family uses a managed Service Network to simplify the resource sharing process.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.transfer.CfnConnector.ConnectorEgressConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-egressconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-egressconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEgressConfig() {
        return null;
    }

    /**
     * Type of egress configuration for the connector.
     * <p>
     * SERVICE_MANAGED uses Transfer Family managed NAT gateways, while VPC_LATTICE routes traffic through customer VPCs using VPC Lattice.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-egresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-egresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEgressType() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
     * <p>
     * When set, you can view connector activity in your CloudWatch logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-loggingrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-loggingrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return null;
    }

    /**
     * The text name of the security policy for the specified connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-securitypolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-securitypolicyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicyName() {
        return null;
    }

    /**
     * A structure that contains the parameters for an SFTP connector object.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.transfer.CfnConnector.SftpConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSftpConfig() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for connectors.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The URL of the partner's AS2 or SFTP endpoint.
     * <p>
     * When creating AS2 connectors or service-managed SFTP connectors (connectors without egress configuration), you must provide a URL to specify the remote server endpoint. For VPC Lattice type connectors, the URL must be null.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-url</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectorProps> {
        java.lang.String accessRole;
        java.lang.Object as2Config;
        java.lang.Object egressConfig;
        java.lang.String egressType;
        java.lang.String loggingRole;
        java.lang.String securityPolicyName;
        java.lang.Object sftpConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String url;

        /**
         * Sets the value of {@link CfnConnectorProps#getAccessRole}
         * @param accessRole Connectors are used to send files using either the AS2 or SFTP protocol. This parameter is required.
         *                   For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
         *                   <p>
         *                   <em>For AS2 connectors</em>
         *                   <p>
         *                   With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         *                   <p>
         *                   If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
         *                   <p>
         *                   <em>For SFTP connectors</em>
         *                   <p>
         *                   Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(java.lang.String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getAs2Config}
         * @param as2Config A structure that contains the parameters for an AS2 connector object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder as2Config(java.lang.Object as2Config) {
            this.as2Config = as2Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getEgressConfig}
         * @param egressConfig Current egress configuration of the connector, showing how traffic is routed to the SFTP server.
         *                     Contains VPC Lattice settings when using VPC_LATTICE egress type.
         *                     <p>
         *                     When using the VPC_LATTICE egress type, AWS Transfer Family uses a managed Service Network to simplify the resource sharing process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressConfig(software.amazon.awscdk.IResolvable egressConfig) {
            this.egressConfig = egressConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getEgressConfig}
         * @param egressConfig Current egress configuration of the connector, showing how traffic is routed to the SFTP server.
         *                     Contains VPC Lattice settings when using VPC_LATTICE egress type.
         *                     <p>
         *                     When using the VPC_LATTICE egress type, AWS Transfer Family uses a managed Service Network to simplify the resource sharing process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressConfig(software.amazon.awscdk.services.transfer.CfnConnector.ConnectorEgressConfigProperty egressConfig) {
            this.egressConfig = egressConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getEgressType}
         * @param egressType Type of egress configuration for the connector.
         *                   SERVICE_MANAGED uses Transfer Family managed NAT gateways, while VPC_LATTICE routes traffic through customer VPCs using VPC Lattice.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressType(java.lang.String egressType) {
            this.egressType = egressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getLoggingRole}
         * @param loggingRole The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
         *                    When set, you can view connector activity in your CloudWatch logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(java.lang.String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getSecurityPolicyName}
         * @param securityPolicyName The text name of the security policy for the specified connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicyName(java.lang.String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getSftpConfig}
         * @param sftpConfig A structure that contains the parameters for an SFTP connector object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sftpConfig(software.amazon.awscdk.IResolvable sftpConfig) {
            this.sftpConfig = sftpConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getSftpConfig}
         * @param sftpConfig A structure that contains the parameters for an SFTP connector object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sftpConfig(software.amazon.awscdk.services.transfer.CfnConnector.SftpConfigProperty sftpConfig) {
            this.sftpConfig = sftpConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for connectors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getUrl}
         * @param url The URL of the partner's AS2 or SFTP endpoint.
         *            When creating AS2 connectors or service-managed SFTP connectors (connectors without egress configuration), you must provide a URL to specify the remote server endpoint. For VPC Lattice type connectors, the URL must be null.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectorProps {
        private final java.lang.String accessRole;
        private final java.lang.Object as2Config;
        private final java.lang.Object egressConfig;
        private final java.lang.String egressType;
        private final java.lang.String loggingRole;
        private final java.lang.String securityPolicyName;
        private final java.lang.Object sftpConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String url;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessRole = software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.as2Config = software.amazon.jsii.Kernel.get(this, "as2Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.egressConfig = software.amazon.jsii.Kernel.get(this, "egressConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.egressType = software.amazon.jsii.Kernel.get(this, "egressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingRole = software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityPolicyName = software.amazon.jsii.Kernel.get(this, "securityPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sftpConfig = software.amazon.jsii.Kernel.get(this, "sftpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessRole = java.util.Objects.requireNonNull(builder.accessRole, "accessRole is required");
            this.as2Config = builder.as2Config;
            this.egressConfig = builder.egressConfig;
            this.egressType = builder.egressType;
            this.loggingRole = builder.loggingRole;
            this.securityPolicyName = builder.securityPolicyName;
            this.sftpConfig = builder.sftpConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.url = builder.url;
        }

        @Override
        public final java.lang.String getAccessRole() {
            return this.accessRole;
        }

        @Override
        public final java.lang.Object getAs2Config() {
            return this.as2Config;
        }

        @Override
        public final java.lang.Object getEgressConfig() {
            return this.egressConfig;
        }

        @Override
        public final java.lang.String getEgressType() {
            return this.egressType;
        }

        @Override
        public final java.lang.String getLoggingRole() {
            return this.loggingRole;
        }

        @Override
        public final java.lang.String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        @Override
        public final java.lang.Object getSftpConfig() {
            return this.sftpConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUrl() {
            return this.url;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessRole", om.valueToTree(this.getAccessRole()));
            if (this.getAs2Config() != null) {
                data.set("as2Config", om.valueToTree(this.getAs2Config()));
            }
            if (this.getEgressConfig() != null) {
                data.set("egressConfig", om.valueToTree(this.getEgressConfig()));
            }
            if (this.getEgressType() != null) {
                data.set("egressType", om.valueToTree(this.getEgressType()));
            }
            if (this.getLoggingRole() != null) {
                data.set("loggingRole", om.valueToTree(this.getLoggingRole()));
            }
            if (this.getSecurityPolicyName() != null) {
                data.set("securityPolicyName", om.valueToTree(this.getSecurityPolicyName()));
            }
            if (this.getSftpConfig() != null) {
                data.set("sftpConfig", om.valueToTree(this.getSftpConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUrl() != null) {
                data.set("url", om.valueToTree(this.getUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnConnectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectorProps.Jsii$Proxy that = (CfnConnectorProps.Jsii$Proxy) o;

            if (!accessRole.equals(that.accessRole)) return false;
            if (this.as2Config != null ? !this.as2Config.equals(that.as2Config) : that.as2Config != null) return false;
            if (this.egressConfig != null ? !this.egressConfig.equals(that.egressConfig) : that.egressConfig != null) return false;
            if (this.egressType != null ? !this.egressType.equals(that.egressType) : that.egressType != null) return false;
            if (this.loggingRole != null ? !this.loggingRole.equals(that.loggingRole) : that.loggingRole != null) return false;
            if (this.securityPolicyName != null ? !this.securityPolicyName.equals(that.securityPolicyName) : that.securityPolicyName != null) return false;
            if (this.sftpConfig != null ? !this.sftpConfig.equals(that.sftpConfig) : that.sftpConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.url != null ? this.url.equals(that.url) : that.url == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessRole.hashCode();
            result = 31 * result + (this.as2Config != null ? this.as2Config.hashCode() : 0);
            result = 31 * result + (this.egressConfig != null ? this.egressConfig.hashCode() : 0);
            result = 31 * result + (this.egressType != null ? this.egressType.hashCode() : 0);
            result = 31 * result + (this.loggingRole != null ? this.loggingRole.hashCode() : 0);
            result = 31 * result + (this.securityPolicyName != null ? this.securityPolicyName.hashCode() : 0);
            result = 31 * result + (this.sftpConfig != null ? this.sftpConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}
