package software.amazon.awscdk.services.workspaces;

/**
 * Properties for defining a <code>CfnWorkspacesPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspaces.*;
 * CfnWorkspacesPoolProps cfnWorkspacesPoolProps = CfnWorkspacesPoolProps.builder()
 *         .bundleId("bundleId")
 *         .capacity(CapacityProperty.builder()
 *                 .desiredUserSessions(123)
 *                 .build())
 *         .directoryId("directoryId")
 *         .poolName("poolName")
 *         // the properties below are optional
 *         .applicationSettings(ApplicationSettingsProperty.builder()
 *                 .status("status")
 *                 // the properties below are optional
 *                 .settingsGroup("settingsGroup")
 *                 .build())
 *         .description("description")
 *         .runningMode("runningMode")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutSettings(TimeoutSettingsProperty.builder()
 *                 .disconnectTimeoutInSeconds(123)
 *                 .idleDisconnectTimeoutInSeconds(123)
 *                 .maxUserDurationInSeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.636Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspaces.CfnWorkspacesPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkspacesPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkspacesPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the bundle used by the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-bundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBundleId();

    /**
     * Describes the user capacity for the pool.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.CapacityProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-capacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCapacity();

    /**
     * The identifier of the directory used by the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-directoryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-directoryid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectoryId();

    /**
     * The name of the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-poolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-poolname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPoolName();

    /**
     * The persistent application settings for users of the pool.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.ApplicationSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-applicationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-applicationsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationSettings() {
        return null;
    }

    /**
     * The description of the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The running mode of the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-runningmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-runningmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRunningMode() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-tags</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The amount of time that a pool session remains active after users disconnect.
     * <p>
     * If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.TimeoutSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-timeoutsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspacespool.html#cfn-workspaces-workspacespool-timeoutsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutSettings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkspacesPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkspacesPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkspacesPoolProps> {
        java.lang.String bundleId;
        java.lang.Object capacity;
        java.lang.String directoryId;
        java.lang.String poolName;
        java.lang.Object applicationSettings;
        java.lang.String description;
        java.lang.String runningMode;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object timeoutSettings;

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getBundleId}
         * @param bundleId The identifier of the bundle used by the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(java.lang.String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getCapacity}
         * @param capacity Describes the user capacity for the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.IResolvable capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getCapacity}
         * @param capacity Describes the user capacity for the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.CapacityProperty capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getDirectoryId}
         * @param directoryId The identifier of the directory used by the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryId(java.lang.String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getPoolName}
         * @param poolName The name of the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolName(java.lang.String poolName) {
            this.poolName = poolName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getApplicationSettings}
         * @param applicationSettings The persistent application settings for users of the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSettings(software.amazon.awscdk.IResolvable applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getApplicationSettings}
         * @param applicationSettings The persistent application settings for users of the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSettings(software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.ApplicationSettingsProperty applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getDescription}
         * @param description The description of the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getRunningMode}
         * @param runningMode The running mode of the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runningMode(java.lang.String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getTimeoutSettings}
         * @param timeoutSettings The amount of time that a pool session remains active after users disconnect.
         *                        If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutSettings(software.amazon.awscdk.IResolvable timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspacesPoolProps#getTimeoutSettings}
         * @param timeoutSettings The amount of time that a pool session remains active after users disconnect.
         *                        If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutSettings(software.amazon.awscdk.services.workspaces.CfnWorkspacesPool.TimeoutSettingsProperty timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkspacesPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkspacesPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkspacesPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkspacesPoolProps {
        private final java.lang.String bundleId;
        private final java.lang.Object capacity;
        private final java.lang.String directoryId;
        private final java.lang.String poolName;
        private final java.lang.Object applicationSettings;
        private final java.lang.String description;
        private final java.lang.String runningMode;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object timeoutSettings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bundleId = software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.directoryId = software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.poolName = software.amazon.jsii.Kernel.get(this, "poolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationSettings = software.amazon.jsii.Kernel.get(this, "applicationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runningMode = software.amazon.jsii.Kernel.get(this, "runningMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeoutSettings = software.amazon.jsii.Kernel.get(this, "timeoutSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bundleId = java.util.Objects.requireNonNull(builder.bundleId, "bundleId is required");
            this.capacity = java.util.Objects.requireNonNull(builder.capacity, "capacity is required");
            this.directoryId = java.util.Objects.requireNonNull(builder.directoryId, "directoryId is required");
            this.poolName = java.util.Objects.requireNonNull(builder.poolName, "poolName is required");
            this.applicationSettings = builder.applicationSettings;
            this.description = builder.description;
            this.runningMode = builder.runningMode;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeoutSettings = builder.timeoutSettings;
        }

        @Override
        public final java.lang.String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final java.lang.Object getCapacity() {
            return this.capacity;
        }

        @Override
        public final java.lang.String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final java.lang.String getPoolName() {
            return this.poolName;
        }

        @Override
        public final java.lang.Object getApplicationSettings() {
            return this.applicationSettings;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRunningMode() {
            return this.runningMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTimeoutSettings() {
            return this.timeoutSettings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bundleId", om.valueToTree(this.getBundleId()));
            data.set("capacity", om.valueToTree(this.getCapacity()));
            data.set("directoryId", om.valueToTree(this.getDirectoryId()));
            data.set("poolName", om.valueToTree(this.getPoolName()));
            if (this.getApplicationSettings() != null) {
                data.set("applicationSettings", om.valueToTree(this.getApplicationSettings()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRunningMode() != null) {
                data.set("runningMode", om.valueToTree(this.getRunningMode()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeoutSettings() != null) {
                data.set("timeoutSettings", om.valueToTree(this.getTimeoutSettings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspaces.CfnWorkspacesPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkspacesPoolProps.Jsii$Proxy that = (CfnWorkspacesPoolProps.Jsii$Proxy) o;

            if (!bundleId.equals(that.bundleId)) return false;
            if (!capacity.equals(that.capacity)) return false;
            if (!directoryId.equals(that.directoryId)) return false;
            if (!poolName.equals(that.poolName)) return false;
            if (this.applicationSettings != null ? !this.applicationSettings.equals(that.applicationSettings) : that.applicationSettings != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.runningMode != null ? !this.runningMode.equals(that.runningMode) : that.runningMode != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeoutSettings != null ? this.timeoutSettings.equals(that.timeoutSettings) : that.timeoutSettings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bundleId.hashCode();
            result = 31 * result + (this.capacity.hashCode());
            result = 31 * result + (this.directoryId.hashCode());
            result = 31 * result + (this.poolName.hashCode());
            result = 31 * result + (this.applicationSettings != null ? this.applicationSettings.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.runningMode != null ? this.runningMode.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeoutSettings != null ? this.timeoutSettings.hashCode() : 0);
            return result;
        }
    }
}
