package software.amazon.awscdk.triggers;

/**
 * Props for <code>Trigger</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.triggers.*;
 * Function func = Function.Builder.create(this, "MyFunction")
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .code(Code.fromInline("foo"))
 *         .build();
 * Trigger.Builder.create(this, "MyTrigger")
 *         .handler(func)
 *         .timeout(Duration.minutes(10))
 *         .invocationType(InvocationType.EVENT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.209Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.triggers.TriggerProps")
@software.amazon.jsii.Jsii.Proxy(TriggerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TriggerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.triggers.TriggerOptions {

    /**
     * The AWS Lambda function of the handler to execute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Function getHandler();

    /**
     * The invocation type to invoke the Lambda function with.
     * <p>
     * Default: RequestResponse
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.triggers.InvocationType getInvocationType() {
        return null;
    }

    /**
     * The timeout of the invocation call of the Lambda function to be triggered.
     * <p>
     * Default: Duration.minutes(2)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TriggerProps> {
        software.amazon.awscdk.services.lambda.Function handler;
        software.amazon.awscdk.triggers.InvocationType invocationType;
        software.amazon.awscdk.Duration timeout;
        java.util.List<software.constructs.Construct> executeAfter;
        java.util.List<software.constructs.Construct> executeBefore;
        java.lang.Boolean executeOnHandlerChange;

        /**
         * Sets the value of {@link TriggerProps#getHandler}
         * @param handler The AWS Lambda function of the handler to execute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(software.amazon.awscdk.services.lambda.Function handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getInvocationType}
         * @param invocationType The invocation type to invoke the Lambda function with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationType(software.amazon.awscdk.triggers.InvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getTimeout}
         * @param timeout The timeout of the invocation call of the Lambda function to be triggered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getExecuteAfter}
         * @param executeAfter Adds trigger dependencies. Execute this trigger only after these construct scopes have been provisioned.
         *                     You can also use <code>trigger.executeAfter()</code> to add additional dependencies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder executeAfter(java.util.List<? extends software.constructs.Construct> executeAfter) {
            this.executeAfter = (java.util.List<software.constructs.Construct>)executeAfter;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getExecuteBefore}
         * @param executeBefore Adds this trigger as a dependency on other constructs.
         *                      This means that this
         *                      trigger will get executed <em>before</em> the given construct(s).
         *                      <p>
         *                      You can also use <code>trigger.executeBefore()</code> to add additional dependants.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder executeBefore(java.util.List<? extends software.constructs.Construct> executeBefore) {
            this.executeBefore = (java.util.List<software.constructs.Construct>)executeBefore;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getExecuteOnHandlerChange}
         * @param executeOnHandlerChange Re-executes the trigger every time the handler changes.
         *                               This implies that the trigger is associated with the <code>currentVersion</code> of
         *                               the handler, which gets recreated every time the handler or its
         *                               configuration is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executeOnHandlerChange(java.lang.Boolean executeOnHandlerChange) {
            this.executeOnHandlerChange = executeOnHandlerChange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TriggerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TriggerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerProps {
        private final software.amazon.awscdk.services.lambda.Function handler;
        private final software.amazon.awscdk.triggers.InvocationType invocationType;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.List<software.constructs.Construct> executeAfter;
        private final java.util.List<software.constructs.Construct> executeBefore;
        private final java.lang.Boolean executeOnHandlerChange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.triggers.InvocationType.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.executeAfter = software.amazon.jsii.Kernel.get(this, "executeAfter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class)));
            this.executeBefore = software.amazon.jsii.Kernel.get(this, "executeBefore", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class)));
            this.executeOnHandlerChange = software.amazon.jsii.Kernel.get(this, "executeOnHandlerChange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.handler = java.util.Objects.requireNonNull(builder.handler, "handler is required");
            this.invocationType = builder.invocationType;
            this.timeout = builder.timeout;
            this.executeAfter = (java.util.List<software.constructs.Construct>)builder.executeAfter;
            this.executeBefore = (java.util.List<software.constructs.Construct>)builder.executeBefore;
            this.executeOnHandlerChange = builder.executeOnHandlerChange;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getHandler() {
            return this.handler;
        }

        @Override
        public final software.amazon.awscdk.triggers.InvocationType getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.List<software.constructs.Construct> getExecuteAfter() {
            return this.executeAfter;
        }

        @Override
        public final java.util.List<software.constructs.Construct> getExecuteBefore() {
            return this.executeBefore;
        }

        @Override
        public final java.lang.Boolean getExecuteOnHandlerChange() {
            return this.executeOnHandlerChange;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("handler", om.valueToTree(this.getHandler()));
            if (this.getInvocationType() != null) {
                data.set("invocationType", om.valueToTree(this.getInvocationType()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getExecuteAfter() != null) {
                data.set("executeAfter", om.valueToTree(this.getExecuteAfter()));
            }
            if (this.getExecuteBefore() != null) {
                data.set("executeBefore", om.valueToTree(this.getExecuteBefore()));
            }
            if (this.getExecuteOnHandlerChange() != null) {
                data.set("executeOnHandlerChange", om.valueToTree(this.getExecuteOnHandlerChange()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.triggers.TriggerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TriggerProps.Jsii$Proxy that = (TriggerProps.Jsii$Proxy) o;

            if (!handler.equals(that.handler)) return false;
            if (this.invocationType != null ? !this.invocationType.equals(that.invocationType) : that.invocationType != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.executeAfter != null ? !this.executeAfter.equals(that.executeAfter) : that.executeAfter != null) return false;
            if (this.executeBefore != null ? !this.executeBefore.equals(that.executeBefore) : that.executeBefore != null) return false;
            return this.executeOnHandlerChange != null ? this.executeOnHandlerChange.equals(that.executeOnHandlerChange) : that.executeOnHandlerChange == null;
        }

        @Override
        public final int hashCode() {
            int result = this.handler.hashCode();
            result = 31 * result + (this.invocationType != null ? this.invocationType.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.executeAfter != null ? this.executeAfter.hashCode() : 0);
            result = 31 * result + (this.executeBefore != null ? this.executeBefore.hashCode() : 0);
            result = 31 * result + (this.executeOnHandlerChange != null ? this.executeOnHandlerChange.hashCode() : 0);
            return result;
        }
    }
}
