package software.amazon.awscdk;

/**
 * Properties for AWS EventBridge event metadata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.mixins.preview.services.s3.events.BucketEvents;
 * Bucket bucket;
 * BucketEvents bucketEvents = BucketEvents.fromBucket(bucket);
 * EventPattern pattern = bucketEvents.objectCreatedPattern(ObjectCreatedProps.builder()
 *         .eventMetadata(AWSEventMetadataProps.builder()
 *                 .region(List.of("us-east-1", "us-west-2"))
 *                 .version(List.of("0"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:12.602Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.AWSEventMetadataProps")
@software.amazon.jsii.Jsii.Proxy(AWSEventMetadataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AWSEventMetadataProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifies the AWS region where the event originated.
     * <p>
     * Default: - No filtering on region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegion() {
        return null;
    }

    /**
     * This JSON array contains ARNs that identify resources that are involved in the event.
     * <p>
     * Inclusion of these ARNs is at the discretion of the
     * service.
     * <p>
     * For example, Amazon EC2 instance state-changes include Amazon EC2
     * instance ARNs, Auto Scaling events include ARNs for both instances and
     * Auto Scaling groups, but API calls with AWS CloudTrail do not include
     * resource ARNs.
     * <p>
     * Default: - No filtering on resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * By default, this is set to 0 (zero) in all events.
     * <p>
     * Default: - No filtering on version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AWSEventMetadataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AWSEventMetadataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AWSEventMetadataProps> {
        java.util.List<java.lang.String> region;
        java.util.List<java.lang.String> resources;
        java.util.List<java.lang.String> version;

        /**
         * Sets the value of {@link AWSEventMetadataProps#getRegion}
         * @param region Identifies the AWS region where the event originated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.util.List<java.lang.String> region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link AWSEventMetadataProps#getResources}
         * @param resources This JSON array contains ARNs that identify resources that are involved in the event.
         *                  Inclusion of these ARNs is at the discretion of the
         *                  service.
         *                  <p>
         *                  For example, Amazon EC2 instance state-changes include Amazon EC2
         *                  instance ARNs, Auto Scaling events include ARNs for both instances and
         *                  Auto Scaling groups, but API calls with AWS CloudTrail do not include
         *                  resource ARNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link AWSEventMetadataProps#getVersion}
         * @param version By default, this is set to 0 (zero) in all events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.util.List<java.lang.String> version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AWSEventMetadataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AWSEventMetadataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AWSEventMetadataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AWSEventMetadataProps {
        private final java.util.List<java.lang.String> region;
        private final java.util.List<java.lang.String> resources;
        private final java.util.List<java.lang.String> version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.region = builder.region;
            this.resources = builder.resources;
            this.version = builder.version;
        }

        @Override
        public final java.util.List<java.lang.String> getRegion() {
            return this.region;
        }

        @Override
        public final java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public final java.util.List<java.lang.String> getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.AWSEventMetadataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AWSEventMetadataProps.Jsii$Proxy that = (AWSEventMetadataProps.Jsii$Proxy) o;

            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.region != null ? this.region.hashCode() : 0;
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
