package software.amazon.awscdk;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // add service account
 * ServiceAccount serviceAccount = cluster.addServiceAccount("MyServiceAccount");
 * Bucket bucket = new Bucket(this, "Bucket");
 * bucket.grantReadWrite(serviceAccount);
 * KubernetesManifest mypod = cluster.addManifest("mypod", Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Pod",
 *         "metadata", Map.of("name", "mypod"),
 *         "spec", Map.of(
 *                 "serviceAccountName", serviceAccount.getServiceAccountName(),
 *                 "containers", List.of(Map.of(
 *                         "name", "hello",
 *                         "image", "paulbouwer/hello-kubernetes:1.5",
 *                         "ports", List.of(Map.of("containerPort", 8080)))))));
 * // create the resource after the service account.
 * mypod.node.addDependency(serviceAccount);
 * // print the IAM role arn for this service account
 * // print the IAM role arn for this service account
 * CfnOutput.Builder.create(this, "ServiceAccountIamRole").value(serviceAccount.getRole().getRoleArn()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:12.695Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnOutputProps")
@software.amazon.jsii.Jsii.Proxy(CfnOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value of the property returned by the aws cloudformation describe-stacks command.
     * <p>
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * A condition to associate with this output value.
     * <p>
     * If the condition evaluates
     * to <code>false</code>, this output value will not be included in the stack.
     * <p>
     * Default: - No condition is associated with the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnCondition getCondition() {
        return null;
    }

    /**
     * A String type that describes the output value.
     * <p>
     * The description can be a maximum of 4 K in length.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name used to export the value of this output across stacks.
     * <p>
     * To import the value from another stack, use <code>Fn.importValue(exportName)</code>.
     * <p>
     * Default: - the output is not exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExportName() {
        return null;
    }

    /**
     * The key of the property returned by aws cloudformation describe-stacks command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOutputProps> {
        java.lang.String value;
        software.amazon.awscdk.CfnCondition condition;
        java.lang.String description;
        java.lang.String exportName;
        java.lang.String key;

        /**
         * Sets the value of {@link CfnOutputProps#getValue}
         * @param value The value of the property returned by the aws cloudformation describe-stacks command. This parameter is required.
         *              The value of an output can include literals, parameter references, pseudo-parameters,
         *              a mapping value, or intrinsic functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getCondition}
         * @param condition A condition to associate with this output value.
         *                  If the condition evaluates
         *                  to <code>false</code>, this output value will not be included in the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.CfnCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getDescription}
         * @param description A String type that describes the output value.
         *                    The description can be a maximum of 4 K in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getExportName}
         * @param exportName The name used to export the value of this output across stacks.
         *                   To import the value from another stack, use <code>Fn.importValue(exportName)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportName(java.lang.String exportName) {
            this.exportName = exportName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getKey}
         * @param key The key of the property returned by aws cloudformation describe-stacks command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOutputProps {
        private final java.lang.String value;
        private final software.amazon.awscdk.CfnCondition condition;
        private final java.lang.String description;
        private final java.lang.String exportName;
        private final java.lang.String key;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCondition.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exportName = software.amazon.jsii.Kernel.get(this, "exportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            this.condition = builder.condition;
            this.description = builder.description;
            this.exportName = builder.exportName;
            this.key = builder.key;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.CfnCondition getCondition() {
            return this.condition;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExportName() {
            return this.exportName;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("value", om.valueToTree(this.getValue()));
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExportName() != null) {
                data.set("exportName", om.valueToTree(this.getExportName()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOutputProps.Jsii$Proxy that = (CfnOutputProps.Jsii$Proxy) o;

            if (!value.equals(that.value)) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.exportName != null ? !this.exportName.equals(that.exportName) : that.exportName != null) return false;
            return this.key != null ? this.key.equals(that.key) : that.key == null;
        }

        @Override
        public final int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exportName != null ? this.exportName.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}
