package software.amazon.awscdk;

/**
 * Work with secret values in the CDK.
 * <p>
 * Constructs that need secrets will declare parameters of type <code>SecretValue</code>.
 * <p>
 * The actual values of these secrets should not be committed to your
 * repository, or even end up in the synthesized CloudFormation template. Instead, you should
 * store them in an external system like AWS Secrets Manager or SSM Parameter
 * Store, and you can reference them by calling <code>SecretValue.secretsManager()</code> or
 * <code>SecretValue.ssmSecure()</code>.
 * <p>
 * You can use <code>SecretValue.unsafePlainText()</code> to construct a <code>SecretValue</code> from a
 * literal string, but doing so is highly discouraged.
 * <p>
 * To make sure secret values don't accidentally end up in readable parts
 * of your infrastructure definition (such as the environment variables
 * of an AWS Lambda Function, where everyone who can read the function
 * definition has access to the secret), using secret values directly is not
 * allowed. You must pass them to constructs that accept <code>SecretValue</code>
 * properties, which are guaranteed to use the value only in CloudFormation
 * properties that are write-only.
 * <p>
 * If you are sure that what you are doing is safe, you can call
 * <code>secretValue.unsafeUnwrap()</code> to access the protected string of the secret
 * value.
 * <p>
 * (If you are writing something like an AWS Lambda Function and need to access
 * a secret inside it, make the API call to <code>GetSecretValue</code> directly inside
 * your Lamba's code, instead of using environment variables.)
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Read the secret from Secrets Manager
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction sourceAction = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub_Source")
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .oauthToken(SecretValue.secretsManager("my-github-token"))
 *         .output(sourceOutput)
 *         .branch("develop")
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:12.861Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.SecretValue")
public class SecretValue extends software.amazon.awscdk.Intrinsic {

    protected SecretValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Construct a SecretValue (do not use!).
     * <p>
     * Do not use the constructor directly: use one of the factory functions on the class
     * instead.
     * <p>
     * @param protectedValue This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object protectedValue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IntrinsicProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { protectedValue, options });
    }

    /**
     * Construct a SecretValue (do not use!).
     * <p>
     * Do not use the constructor directly: use one of the factory functions on the class
     * instead.
     * <p>
     * @param protectedValue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object protectedValue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { protectedValue });
    }

    /**
     * Obtain the secret value through a CloudFormation dynamic reference.
     * <p>
     * If possible, use <code>SecretValue.ssmSecure</code> or <code>SecretValue.secretsManager</code> directly.
     * <p>
     * @param ref The dynamic reference to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue cfnDynamicReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnDynamicReference ref) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnDynamicReference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(ref, "ref is required") });
    }

    /**
     * Returns a key which can be used within an AWS CloudFormation dynamic reference to dynamically load a secret from AWS Secrets Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/cfn-example_reference-secret.html">https://docs.aws.amazon.com/secretsmanager/latest/userguide/cfn-example_reference-secret.html</a>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String cfnDynamicReferenceKey(final @org.jetbrains.annotations.NotNull java.lang.String secretId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretsManagerSecretOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnDynamicReferenceKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required"), options });
    }

    /**
     * Returns a key which can be used within an AWS CloudFormation dynamic reference to dynamically load a secret from AWS Secrets Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/cfn-example_reference-secret.html">https://docs.aws.amazon.com/secretsmanager/latest/userguide/cfn-example_reference-secret.html</a>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String cfnDynamicReferenceKey(final @org.jetbrains.annotations.NotNull java.lang.String secretId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnDynamicReferenceKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required") });
    }

    /**
     * Obtain the secret value through a CloudFormation parameter.
     * <p>
     * Generally, this is not a recommended approach. AWS Secrets Manager is the
     * recommended way to reference secrets.
     * <p>
     * @param param The CloudFormation parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue cfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnParameter param) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(param, "param is required") });
    }

    /**
     * Test whether an object is a SecretValue.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isSecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "isSecretValue", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * (deprecated) Construct a literal secret value for use with secret-aware constructs.
     * <p>
     * Do not use this method for any secrets that you care about! The value
     * will be visible to anyone who has access to the CloudFormation template
     * (via the AWS Console, SDKs, or CLI).
     * <p>
     * The only reasonable use case for using this method is when you are testing.
     * <p>
     * @deprecated Use <code>unsafePlainText()</code> instead.
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue plainText(final @org.jetbrains.annotations.NotNull java.lang.String secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "plainText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Use a resource's output as secret value.
     * <p>
     * @param attr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue resourceAttribute(final @org.jetbrains.annotations.NotNull java.lang.String attr) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "resourceAttribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(attr, "attr is required") });
    }

    /**
     * Creates a <code>SecretValue</code> with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * If you rotate the value in the Secret, you must also change at least one property
     * on the resource where you are using the secret, to force CloudFormation to re-read the secret.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretsManagerSecretOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required"), options });
    }

    /**
     * Creates a <code>SecretValue</code> with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * If you rotate the value in the Secret, you must also change at least one property
     * on the resource where you are using the secret, to force CloudFormation to re-read the secret.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required") });
    }

    /**
     * Use a secret value stored from a Systems Manager (SSM) parameter.
     * <p>
     * This secret source in only supported in a limited set of resources and
     * properties. <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#template-parameters-dynamic-patterns-resources">Click here for the list of supported
     * properties</a>.
     * <p>
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store. This parameter is required.
     * @param version An integer that specifies the version of the parameter to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue ssmSecure(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "ssmSecure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), version });
    }

    /**
     * Use a secret value stored from a Systems Manager (SSM) parameter.
     * <p>
     * This secret source in only supported in a limited set of resources and
     * properties. <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#template-parameters-dynamic-patterns-resources">Click here for the list of supported
     * properties</a>.
     * <p>
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue ssmSecure(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "ssmSecure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * Construct a literal secret value for use with secret-aware constructs.
     * <p>
     * Do not use this method for any secrets that you care about! The value
     * will be visible to anyone who has access to the CloudFormation template
     * (via the AWS Console, SDKs, or CLI).
     * <p>
     * The primary use case for using this method is when you are testing.
     * <p>
     * The other use case where this is appropriate is when constructing a JSON secret.
     * For example, a JSON secret might have multiple fields where only some are actual
     * secret values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * SecretValue secret;
     * Map&lt;String, SecretValue&gt; jsonSecret = Map.of(
     *         "username", SecretValue.unsafePlainText("myUsername"),
     *         "password", secret);
     * </pre></blockquote>
     * <p>
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue unsafePlainText(final @org.jetbrains.annotations.NotNull java.lang.String secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "unsafePlainText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Resolve the secret.
     * <p>
     * If the feature flag is not set, resolve as normal. Otherwise, throw a descriptive
     * error that the usage guard is missing.
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * Disable usage protection on this secret.
     * <p>
     * Call this to indicate that you want to use the secret value held by this
     * object in an unchecked way. If you don't call this method, using the secret
     * value directly in a string context or as a property value somewhere will
     * produce an error.
     * <p>
     * This method has 'unsafe' in the name on purpose! Make sure that the
     * construct property you are using the returned value in is does not end up
     * in a place in your AWS infrastructure where it could be read by anyone
     * unexpected.
     * <p>
     * When in doubt, don't call this method and only pass the object to constructs that
     * accept <code>SecretValue</code> parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String unsafeUnwrap() {
        return software.amazon.jsii.Kernel.call(this, "unsafeUnwrap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.SecretValue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.SecretValue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param protectedValue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.Object protectedValue) {
            return new Builder(protectedValue);
        }

        private final java.lang.Object protectedValue;
        private software.amazon.awscdk.IntrinsicProps.Builder options;

        private Builder(final java.lang.Object protectedValue) {
            this.protectedValue = protectedValue;
        }

        /**
         * Capture the stack trace of where this token is created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackTrace Capture the stack trace of where this token is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTrace(final java.lang.Boolean stackTrace) {
            this.options().stackTrace(stackTrace);
            return this;
        }

        /**
         * Type that this token is expected to evaluate to.
         * <p>
         * Default: ResolutionTypeHint.STRING
         * <p>
         * @return {@code this}
         * @param typeHint Type that this token is expected to evaluate to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeHint(final software.amazon.awscdk.ResolutionTypeHint typeHint) {
            this.options().typeHint(typeHint);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.SecretValue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.SecretValue build() {
            return new software.amazon.awscdk.SecretValue(
                this.protectedValue,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.IntrinsicProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.IntrinsicProps.Builder();
            }
            return this.options;
        }
    }
}
