package software.amazon.awscdk;

/**
 * Manages AWS tags for all resources within a construct scope.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * Tags.of(node).add("Environment", "Dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:12.894Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Tags")
public class Tags extends software.amazon.jsii.JsiiObject {

    protected Tags(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Tags(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the tags API for this scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Tags of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Tags.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Tags.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Add tags to the node of a construct and all its the taggable children.
     * <p>
     * <h2>Tagging and CloudFormation Stacks</h2>
     * <p>
     * If the feature flag <code>&#64;aws-cdk/core:explicitStackTags</code> is set to <code>true</code>
     * (recommended modern behavior), Stacks will not automatically be tagged.
     * Stack tags should be configured on Stacks directly (preferred), or
     * you must explicitly include the resource type <code>aws:cdk:stack</code> in the
     * <code>includeResourceTypes</code> array.
     * <p>
     * If the feature flag is set to <code>false</code> (legacy behavior) then both Stacks
     * and resources in the indicated scope will both be tagged by default, which
     * leads to tags being applied twice (once in the template, and then once
     * again automatically by CloudFormation as part of the stack deployment).
     * That behavior leads to loss of control as <code>excludeResourceTypes</code> will
     * prevent tags from appearing in the template, but they will still be
     * applied to the Stack and hence CloudFormation will still apply them
     * to the resource.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void add(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TagProps props) {
        software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required"), props });
    }

    /**
     * Add tags to the node of a construct and all its the taggable children.
     * <p>
     * <h2>Tagging and CloudFormation Stacks</h2>
     * <p>
     * If the feature flag <code>&#64;aws-cdk/core:explicitStackTags</code> is set to <code>true</code>
     * (recommended modern behavior), Stacks will not automatically be tagged.
     * Stack tags should be configured on Stacks directly (preferred), or
     * you must explicitly include the resource type <code>aws:cdk:stack</code> in the
     * <code>includeResourceTypes</code> array.
     * <p>
     * If the feature flag is set to <code>false</code> (legacy behavior) then both Stacks
     * and resources in the indicated scope will both be tagged by default, which
     * leads to tags being applied twice (once in the template, and then once
     * again automatically by CloudFormation as part of the stack deployment).
     * That behavior leads to loss of control as <code>excludeResourceTypes</code> will
     * prevent tags from appearing in the template, but they will still be
     * applied to the Stack and hence CloudFormation will still apply them
     * to the resource.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void add(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * remove tags to the node of a construct and all its the taggable children.
     * <p>
     * @param key This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void remove(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TagProps props) {
        software.amazon.jsii.Kernel.call(this, "remove", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), props });
    }

    /**
     * remove tags to the node of a construct and all its the taggable children.
     * <p>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void remove(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        software.amazon.jsii.Kernel.call(this, "remove", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }
}
