package software.amazon.awscdk.assertions;

/**
 * Capture values while matching templates.
 * <p>
 * Using an instance of this class within a Matcher will capture the matching value.
 * The <code>as*()</code> APIs on the instance can be used to get the captured value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Given a template -
 * // {
 * //   "Resources": {
 * //     "MyBar": {
 * //       "Type": "Foo::Bar",
 * //       "Properties": {
 * //         "Fred": "Flob",
 * //       }
 * //     },
 * //     "MyBaz": {
 * //       "Type": "Foo::Bar",
 * //       "Properties": {
 * //         "Fred": "Quib",
 * //       }
 * //     }
 * //   }
 * // }
 * Capture fredCapture = new Capture();
 * template.hasResourceProperties("Foo::Bar", Map.of(
 *         "Fred", fredCapture));
 * fredCapture.asString(); // returns "Flob"
 * fredCapture.next(); // returns true
 * fredCapture.asString();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:12.933Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Capture")
public class Capture extends software.amazon.awscdk.assertions.Matcher {

    protected Capture(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Capture(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initialize a new capture.
     * <p>
     * @param pattern a nested pattern or Matcher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Capture(final @org.jetbrains.annotations.Nullable java.lang.Object pattern) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { pattern });
    }

    /**
     * Initialize a new capture.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Capture() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Retrieve the captured value as an array.
     * <p>
     * An error is generated if no value is captured or if the value is not an array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> asArray() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "asArray", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Retrieve the captured value as a boolean.
     * <p>
     * An error is generated if no value is captured or if the value is not a boolean.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean asBoolean() {
        return software.amazon.jsii.Kernel.call(this, "asBoolean", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Retrieve the captured value as a number.
     * <p>
     * An error is generated if no value is captured or if the value is not a number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number asNumber() {
        return software.amazon.jsii.Kernel.call(this, "asNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Retrieve the captured value as a JSON object.
     * <p>
     * An error is generated if no value is captured or if the value is not an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> asObject() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "asObject", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Retrieve the captured value as a string.
     * <p>
     * An error is generated if no value is captured or if the value is not a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String asString() {
        return software.amazon.jsii.Kernel.call(this, "asString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When multiple results are captured, move the iterator to the next result.
     * <p>
     * @return true if another capture is present, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean next() {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Test whether a target matches the provided pattern.
     * <p>
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     * <p>
     * @param actual This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult test(final @org.jetbrains.annotations.NotNull java.lang.Object actual) {
        return software.amazon.jsii.Kernel.call(this, "test", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class), new Object[] { actual });
    }

    /**
     * A name for the matcher.
     * <p>
     * This is collected as part of the result and may be presented to the user.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
