package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Properties to initialize WebSocketTokenAuthorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.*;
 * WebSocketLambdaAuthorizerProps webSocketLambdaAuthorizerProps = WebSocketLambdaAuthorizerProps.builder()
 *         .authorizerName("authorizerName")
 *         .identitySource(List.of("identitySource"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketLambdaAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketLambdaAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the authorizer.
     * <p>
     * Default: - same value as `id` passed in the constructor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The identity source for which authorization is requested.
     * <p>
     * Request parameter match <code>'route.request.querystring|header.[a-zA-z0-9._-]+'</code>.
     * Staged variable match <code>'stageVariables.[a-zA-Z0-9._-]+'</code>.
     * Context parameter match <code>'context.[a-zA-Z0-9._-]+'</code>.
     * <p>
     * Default: ['route.request.header.Authorization']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentitySource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketLambdaAuthorizerProps> {
        java.lang.String authorizerName;
        java.util.List<java.lang.String> identitySource;

        /**
         * Sets the value of {@link WebSocketLambdaAuthorizerProps#getAuthorizerName}
         * @param authorizerName The name of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketLambdaAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested.
         *                       Request parameter match <code>'route.request.querystring|header.[a-zA-z0-9._-]+'</code>.
         *                       Staged variable match <code>'stageVariables.[a-zA-Z0-9._-]+'</code>.
         *                       Context parameter match <code>'context.[a-zA-Z0-9._-]+'</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketLambdaAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketLambdaAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketLambdaAuthorizerProps {
        private final java.lang.String authorizerName;
        private final java.util.List<java.lang.String> identitySource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerName = builder.authorizerName;
            this.identitySource = builder.identitySource;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketLambdaAuthorizerProps.Jsii$Proxy that = (WebSocketLambdaAuthorizerProps.Jsii$Proxy) o;

            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            return this.identitySource != null ? this.identitySource.equals(that.identitySource) : that.identitySource == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerName != null ? this.authorizerName.hashCode() : 0;
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            return result;
        }
    }
}
