package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * The Service Discovery integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.servicediscovery.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * VpcLink vpcLink = VpcLink.Builder.create(this, "VpcLink").vpc(vpc).build();
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "Namespace")
 *         .name("boobar.com")
 *         .vpc(vpc)
 *         .build();
 * Service service = namespace.createService("Service");
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpServiceDiscoveryIntegration.Builder.create("DefaultIntegration", service)
 *                 .vpcLink(vpcLink)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.626Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration")
public class HttpServiceDiscoveryIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpServiceDiscoveryIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpServiceDiscoveryIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param service the service discovery resource to integrate with. This parameter is required.
     * @param props properties to configure the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpServiceDiscoveryIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(service, "service is required"), props });
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param service the service discovery resource to integrate with. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpServiceDiscoveryIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
        return software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setConnectionType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpConnectionType value) {
        software.amazon.jsii.Kernel.set(this, "connectionType", java.util.Objects.requireNonNull(value, "connectionType is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpMethod getHttpMethod() {
        return software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setHttpMethod(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpMethod value) {
        software.amazon.jsii.Kernel.set(this, "httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getIntegrationType() {
        return software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIntegrationType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType value) {
        software.amazon.jsii.Kernel.set(this, "integrationType", java.util.Objects.requireNonNull(value, "integrationType is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
        return software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setPayloadFormatVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion value) {
        software.amazon.jsii.Kernel.set(this, "payloadFormatVersion", java.util.Objects.requireNonNull(value, "payloadFormatVersion is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         * @param service the service discovery resource to integrate with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.servicediscovery.IService service) {
            return new Builder(id, service);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.IService service;
        private software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegrationProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.servicediscovery.IService service) {
            this.id = id;
            this.service = service;
        }

        /**
         * The HTTP method that must be used to invoke the underlying HTTP proxy.
         * <p>
         * Default: HttpMethod.ANY
         * <p>
         * @return {@code this}
         * @param method The HTTP method that must be used to invoke the underlying HTTP proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.props().method(method);
            return this;
        }

        /**
         * Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: undefined requests are sent to the backend unmodified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props().parameterMapping(parameterMapping);
            return this;
        }

        /**
         * Specifies the server name to verified by HTTPS when calling the backend integration.
         * <p>
         * Default: undefined private integration traffic will use HTTP protocol
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
         * @param secureServerName Specifies the server name to verified by HTTPS when calling the backend integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secureServerName(final java.lang.String secureServerName) {
            this.props().secureServerName(secureServerName);
            return this;
        }

        /**
         * The maximum amount of time an integration will run before it returns without a response.
         * <p>
         * Must be between 50 milliseconds and 29 seconds.
         * <p>
         * Default: Duration.seconds(29)
         * <p>
         * @return {@code this}
         * @param timeout The maximum amount of time an integration will run before it returns without a response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * The vpc link to be used for the private integration.
         * <p>
         * Default: - a new VpcLink is created
         * <p>
         * @return {@code this}
         * @param vpcLink The vpc link to be used for the private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(final software.amazon.awscdk.services.apigatewayv2.IVpcLink vpcLink) {
            this.props().vpcLink(vpcLink);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration(
                this.id,
                this.service,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
