package software.amazon.awscdk.interfaces.apigatewayv2;

/**
 * A reference to a RouteResponse resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.apigatewayv2.*;
 * RouteResponseReference routeResponseReference = RouteResponseReference.builder()
 *         .apiId("apiId")
 *         .routeId("routeId")
 *         .routeResponseId("routeResponseId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.046Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_apigatewayv2.RouteResponseReference")
@software.amazon.jsii.Jsii.Proxy(RouteResponseReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteResponseReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApiId of the RouteResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The RouteId of the RouteResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteId();

    /**
     * The RouteResponseId of the RouteResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteResponseId();

    /**
     * @return a {@link Builder} of {@link RouteResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteResponseReference> {
        java.lang.String apiId;
        java.lang.String routeId;
        java.lang.String routeResponseId;

        /**
         * Sets the value of {@link RouteResponseReference#getApiId}
         * @param apiId The ApiId of the RouteResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link RouteResponseReference#getRouteId}
         * @param routeId The RouteId of the RouteResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeId(java.lang.String routeId) {
            this.routeId = routeId;
            return this;
        }

        /**
         * Sets the value of {@link RouteResponseReference#getRouteResponseId}
         * @param routeResponseId The RouteResponseId of the RouteResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeResponseId(java.lang.String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteResponseReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteResponseReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteResponseReference {
        private final java.lang.String apiId;
        private final java.lang.String routeId;
        private final java.lang.String routeResponseId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeId = software.amazon.jsii.Kernel.get(this, "routeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeResponseId = software.amazon.jsii.Kernel.get(this, "routeResponseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.routeId = java.util.Objects.requireNonNull(builder.routeId, "routeId is required");
            this.routeResponseId = java.util.Objects.requireNonNull(builder.routeResponseId, "routeResponseId is required");
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getRouteId() {
            return this.routeId;
        }

        @Override
        public final java.lang.String getRouteResponseId() {
            return this.routeResponseId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("routeId", om.valueToTree(this.getRouteId()));
            data.set("routeResponseId", om.valueToTree(this.getRouteResponseId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_apigatewayv2.RouteResponseReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteResponseReference.Jsii$Proxy that = (RouteResponseReference.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!routeId.equals(that.routeId)) return false;
            return this.routeResponseId.equals(that.routeResponseId);
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.routeId.hashCode());
            result = 31 * result + (this.routeResponseId.hashCode());
            return result;
        }
    }
}
