package software.amazon.awscdk.interfaces.appconfig;

/**
 * A reference to a Deployment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appconfig.*;
 * DeploymentReference deploymentReference = DeploymentReference.builder()
 *         .applicationId("applicationId")
 *         .deploymentNumber("deploymentNumber")
 *         .environmentId("environmentId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.048Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appconfig.DeploymentReference")
@software.amazon.jsii.Jsii.Proxy(DeploymentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationId of the Deployment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The DeploymentNumber of the Deployment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentNumber();

    /**
     * The EnvironmentId of the Deployment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId();

    /**
     * @return a {@link Builder} of {@link DeploymentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentReference> {
        java.lang.String applicationId;
        java.lang.String deploymentNumber;
        java.lang.String environmentId;

        /**
         * Sets the value of {@link DeploymentReference#getApplicationId}
         * @param applicationId The ApplicationId of the Deployment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentReference#getDeploymentNumber}
         * @param deploymentNumber The DeploymentNumber of the Deployment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentNumber(java.lang.String deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentReference#getEnvironmentId}
         * @param environmentId The EnvironmentId of the Deployment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentId(java.lang.String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentReference {
        private final java.lang.String applicationId;
        private final java.lang.String deploymentNumber;
        private final java.lang.String environmentId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentNumber = software.amazon.jsii.Kernel.get(this, "deploymentNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentId = software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.deploymentNumber = java.util.Objects.requireNonNull(builder.deploymentNumber, "deploymentNumber is required");
            this.environmentId = java.util.Objects.requireNonNull(builder.environmentId, "environmentId is required");
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getDeploymentNumber() {
            return this.deploymentNumber;
        }

        @Override
        public final java.lang.String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("deploymentNumber", om.valueToTree(this.getDeploymentNumber()));
            data.set("environmentId", om.valueToTree(this.getEnvironmentId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appconfig.DeploymentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentReference.Jsii$Proxy that = (DeploymentReference.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!deploymentNumber.equals(that.deploymentNumber)) return false;
            return this.environmentId.equals(that.environmentId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.deploymentNumber.hashCode());
            result = 31 * result + (this.environmentId.hashCode());
            return result;
        }
    }
}
