package software.amazon.awscdk.interfaces.appconfig;

/**
 * A reference to a ExtensionAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appconfig.*;
 * ExtensionAssociationReference extensionAssociationReference = ExtensionAssociationReference.builder()
 *         .extensionAssociationArn("extensionAssociationArn")
 *         .extensionAssociationId("extensionAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.049Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appconfig.ExtensionAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ExtensionAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExtensionAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ExtensionAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExtensionAssociationArn();

    /**
     * The Id of the ExtensionAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExtensionAssociationId();

    /**
     * @return a {@link Builder} of {@link ExtensionAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtensionAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExtensionAssociationReference> {
        java.lang.String extensionAssociationArn;
        java.lang.String extensionAssociationId;

        /**
         * Sets the value of {@link ExtensionAssociationReference#getExtensionAssociationArn}
         * @param extensionAssociationArn The ARN of the ExtensionAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionAssociationArn(java.lang.String extensionAssociationArn) {
            this.extensionAssociationArn = extensionAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAssociationReference#getExtensionAssociationId}
         * @param extensionAssociationId The Id of the ExtensionAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionAssociationId(java.lang.String extensionAssociationId) {
            this.extensionAssociationId = extensionAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtensionAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExtensionAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtensionAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionAssociationReference {
        private final java.lang.String extensionAssociationArn;
        private final java.lang.String extensionAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.extensionAssociationArn = software.amazon.jsii.Kernel.get(this, "extensionAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extensionAssociationId = software.amazon.jsii.Kernel.get(this, "extensionAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.extensionAssociationArn = java.util.Objects.requireNonNull(builder.extensionAssociationArn, "extensionAssociationArn is required");
            this.extensionAssociationId = java.util.Objects.requireNonNull(builder.extensionAssociationId, "extensionAssociationId is required");
        }

        @Override
        public final java.lang.String getExtensionAssociationArn() {
            return this.extensionAssociationArn;
        }

        @Override
        public final java.lang.String getExtensionAssociationId() {
            return this.extensionAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("extensionAssociationArn", om.valueToTree(this.getExtensionAssociationArn()));
            data.set("extensionAssociationId", om.valueToTree(this.getExtensionAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appconfig.ExtensionAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtensionAssociationReference.Jsii$Proxy that = (ExtensionAssociationReference.Jsii$Proxy) o;

            if (!extensionAssociationArn.equals(that.extensionAssociationArn)) return false;
            return this.extensionAssociationId.equals(that.extensionAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.extensionAssociationArn.hashCode();
            result = 31 * result + (this.extensionAssociationId.hashCode());
            return result;
        }
    }
}
