package software.amazon.awscdk.interfaces.appflow;

/**
 * A reference to a ConnectorProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appflow.*;
 * ConnectorProfileReference connectorProfileReference = ConnectorProfileReference.builder()
 *         .connectorProfileArn("connectorProfileArn")
 *         .connectorProfileName("connectorProfileName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.052Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appflow.ConnectorProfileReference")
@software.amazon.jsii.Jsii.Proxy(ConnectorProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectorProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConnectorProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorProfileArn();

    /**
     * The ConnectorProfileName of the ConnectorProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorProfileName();

    /**
     * @return a {@link Builder} of {@link ConnectorProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectorProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfileReference> {
        java.lang.String connectorProfileArn;
        java.lang.String connectorProfileName;

        /**
         * Sets the value of {@link ConnectorProfileReference#getConnectorProfileArn}
         * @param connectorProfileArn The ARN of the ConnectorProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileArn(java.lang.String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link ConnectorProfileReference#getConnectorProfileName}
         * @param connectorProfileName The ConnectorProfileName of the ConnectorProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileName(java.lang.String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectorProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectorProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectorProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfileReference {
        private final java.lang.String connectorProfileArn;
        private final java.lang.String connectorProfileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectorProfileArn = software.amazon.jsii.Kernel.get(this, "connectorProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectorProfileArn = java.util.Objects.requireNonNull(builder.connectorProfileArn, "connectorProfileArn is required");
            this.connectorProfileName = java.util.Objects.requireNonNull(builder.connectorProfileName, "connectorProfileName is required");
        }

        @Override
        public final java.lang.String getConnectorProfileArn() {
            return this.connectorProfileArn;
        }

        @Override
        public final java.lang.String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectorProfileArn", om.valueToTree(this.getConnectorProfileArn()));
            data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appflow.ConnectorProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectorProfileReference.Jsii$Proxy that = (ConnectorProfileReference.Jsii$Proxy) o;

            if (!connectorProfileArn.equals(that.connectorProfileArn)) return false;
            return this.connectorProfileName.equals(that.connectorProfileName);
        }

        @Override
        public final int hashCode() {
            int result = this.connectorProfileArn.hashCode();
            result = 31 * result + (this.connectorProfileName.hashCode());
            return result;
        }
    }
}
