package software.amazon.awscdk.interfaces.applicationautoscaling;

/**
 * A reference to a ScalableTarget resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.applicationautoscaling.*;
 * ScalableTargetReference scalableTargetReference = ScalableTargetReference.builder()
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .serviceNamespace("serviceNamespace")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.069Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_applicationautoscaling.ScalableTargetReference")
@software.amazon.jsii.Jsii.Proxy(ScalableTargetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScalableTargetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ResourceId of the ScalableTarget resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The ScalableDimension of the ScalableTarget resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension();

    /**
     * The ServiceNamespace of the ScalableTarget resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceNamespace();

    /**
     * @return a {@link Builder} of {@link ScalableTargetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalableTargetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScalableTargetReference> {
        java.lang.String resourceId;
        java.lang.String scalableDimension;
        java.lang.String serviceNamespace;

        /**
         * Sets the value of {@link ScalableTargetReference#getResourceId}
         * @param resourceId The ResourceId of the ScalableTarget resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetReference#getScalableDimension}
         * @param scalableDimension The ScalableDimension of the ScalableTarget resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(java.lang.String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetReference#getServiceNamespace}
         * @param serviceNamespace The ServiceNamespace of the ScalableTarget resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(java.lang.String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalableTargetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScalableTargetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScalableTargetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalableTargetReference {
        private final java.lang.String resourceId;
        private final java.lang.String scalableDimension;
        private final java.lang.String serviceNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalableDimension = software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNamespace = software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.scalableDimension = java.util.Objects.requireNonNull(builder.scalableDimension, "scalableDimension is required");
            this.serviceNamespace = java.util.Objects.requireNonNull(builder.serviceNamespace, "serviceNamespace is required");
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final java.lang.String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
            data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_applicationautoscaling.ScalableTargetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalableTargetReference.Jsii$Proxy that = (ScalableTargetReference.Jsii$Proxy) o;

            if (!resourceId.equals(that.resourceId)) return false;
            if (!scalableDimension.equals(that.scalableDimension)) return false;
            return this.serviceNamespace.equals(that.serviceNamespace);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + (this.scalableDimension.hashCode());
            result = 31 * result + (this.serviceNamespace.hashCode());
            return result;
        }
    }
}
