package software.amazon.awscdk.interfaces.appmesh;

/**
 * A reference to a Mesh resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appmesh.*;
 * MeshReference meshReference = MeshReference.builder()
 *         .meshArn("meshArn")
 *         .meshId("meshId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.075Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appmesh.MeshReference")
@software.amazon.jsii.Jsii.Proxy(MeshReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MeshReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Mesh resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshArn();

    /**
     * The Id of the Mesh resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshId();

    /**
     * @return a {@link Builder} of {@link MeshReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MeshReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MeshReference> {
        java.lang.String meshArn;
        java.lang.String meshId;

        /**
         * Sets the value of {@link MeshReference#getMeshArn}
         * @param meshArn The ARN of the Mesh resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshArn(java.lang.String meshArn) {
            this.meshArn = meshArn;
            return this;
        }

        /**
         * Sets the value of {@link MeshReference#getMeshId}
         * @param meshId The Id of the Mesh resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshId(java.lang.String meshId) {
            this.meshId = meshId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MeshReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MeshReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MeshReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MeshReference {
        private final java.lang.String meshArn;
        private final java.lang.String meshId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meshArn = software.amazon.jsii.Kernel.get(this, "meshArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.meshId = software.amazon.jsii.Kernel.get(this, "meshId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meshArn = java.util.Objects.requireNonNull(builder.meshArn, "meshArn is required");
            this.meshId = java.util.Objects.requireNonNull(builder.meshId, "meshId is required");
        }

        @Override
        public final java.lang.String getMeshArn() {
            return this.meshArn;
        }

        @Override
        public final java.lang.String getMeshId() {
            return this.meshId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meshArn", om.valueToTree(this.getMeshArn()));
            data.set("meshId", om.valueToTree(this.getMeshId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appmesh.MeshReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MeshReference.Jsii$Proxy that = (MeshReference.Jsii$Proxy) o;

            if (!meshArn.equals(that.meshArn)) return false;
            return this.meshId.equals(that.meshId);
        }

        @Override
        public final int hashCode() {
            int result = this.meshArn.hashCode();
            result = 31 * result + (this.meshId.hashCode());
            return result;
        }
    }
}
