package software.amazon.awscdk.interfaces.appmesh;

/**
 * A reference to a VirtualGateway resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appmesh.*;
 * VirtualGatewayReference virtualGatewayReference = VirtualGatewayReference.builder()
 *         .virtualGatewayArn("virtualGatewayArn")
 *         .virtualGatewayId("virtualGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appmesh.VirtualGatewayReference")
@software.amazon.jsii.Jsii.Proxy(VirtualGatewayReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualGatewayReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the VirtualGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayArn();

    /**
     * The Id of the VirtualGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayId();

    /**
     * @return a {@link Builder} of {@link VirtualGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayReference> {
        java.lang.String virtualGatewayArn;
        java.lang.String virtualGatewayId;

        /**
         * Sets the value of {@link VirtualGatewayReference#getVirtualGatewayArn}
         * @param virtualGatewayArn The ARN of the VirtualGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayArn(java.lang.String virtualGatewayArn) {
            this.virtualGatewayArn = virtualGatewayArn;
            return this;
        }

        /**
         * Sets the value of {@link VirtualGatewayReference#getVirtualGatewayId}
         * @param virtualGatewayId The Id of the VirtualGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayId(java.lang.String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualGatewayReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualGatewayReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayReference {
        private final java.lang.String virtualGatewayArn;
        private final java.lang.String virtualGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualGatewayArn = software.amazon.jsii.Kernel.get(this, "virtualGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualGatewayId = software.amazon.jsii.Kernel.get(this, "virtualGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualGatewayArn = java.util.Objects.requireNonNull(builder.virtualGatewayArn, "virtualGatewayArn is required");
            this.virtualGatewayId = java.util.Objects.requireNonNull(builder.virtualGatewayId, "virtualGatewayId is required");
        }

        @Override
        public final java.lang.String getVirtualGatewayArn() {
            return this.virtualGatewayArn;
        }

        @Override
        public final java.lang.String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualGatewayArn", om.valueToTree(this.getVirtualGatewayArn()));
            data.set("virtualGatewayId", om.valueToTree(this.getVirtualGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appmesh.VirtualGatewayReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualGatewayReference.Jsii$Proxy that = (VirtualGatewayReference.Jsii$Proxy) o;

            if (!virtualGatewayArn.equals(that.virtualGatewayArn)) return false;
            return this.virtualGatewayId.equals(that.virtualGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.virtualGatewayArn.hashCode();
            result = 31 * result + (this.virtualGatewayId.hashCode());
            return result;
        }
    }
}
