package software.amazon.awscdk.interfaces.appmesh;

/**
 * A reference to a VirtualNode resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appmesh.*;
 * VirtualNodeReference virtualNodeReference = VirtualNodeReference.builder()
 *         .virtualNodeArn("virtualNodeArn")
 *         .virtualNodeId("virtualNodeId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appmesh.VirtualNodeReference")
@software.amazon.jsii.Jsii.Proxy(VirtualNodeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualNodeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the VirtualNode resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeArn();

    /**
     * The Id of the VirtualNode resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeId();

    /**
     * @return a {@link Builder} of {@link VirtualNodeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualNodeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeReference> {
        java.lang.String virtualNodeArn;
        java.lang.String virtualNodeId;

        /**
         * Sets the value of {@link VirtualNodeReference#getVirtualNodeArn}
         * @param virtualNodeArn The ARN of the VirtualNode resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeArn(java.lang.String virtualNodeArn) {
            this.virtualNodeArn = virtualNodeArn;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeReference#getVirtualNodeId}
         * @param virtualNodeId The Id of the VirtualNode resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeId(java.lang.String virtualNodeId) {
            this.virtualNodeId = virtualNodeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualNodeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualNodeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualNodeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeReference {
        private final java.lang.String virtualNodeArn;
        private final java.lang.String virtualNodeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualNodeArn = software.amazon.jsii.Kernel.get(this, "virtualNodeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualNodeId = software.amazon.jsii.Kernel.get(this, "virtualNodeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualNodeArn = java.util.Objects.requireNonNull(builder.virtualNodeArn, "virtualNodeArn is required");
            this.virtualNodeId = java.util.Objects.requireNonNull(builder.virtualNodeId, "virtualNodeId is required");
        }

        @Override
        public final java.lang.String getVirtualNodeArn() {
            return this.virtualNodeArn;
        }

        @Override
        public final java.lang.String getVirtualNodeId() {
            return this.virtualNodeId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualNodeArn", om.valueToTree(this.getVirtualNodeArn()));
            data.set("virtualNodeId", om.valueToTree(this.getVirtualNodeId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appmesh.VirtualNodeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualNodeReference.Jsii$Proxy that = (VirtualNodeReference.Jsii$Proxy) o;

            if (!virtualNodeArn.equals(that.virtualNodeArn)) return false;
            return this.virtualNodeId.equals(that.virtualNodeId);
        }

        @Override
        public final int hashCode() {
            int result = this.virtualNodeArn.hashCode();
            result = 31 * result + (this.virtualNodeId.hashCode());
            return result;
        }
    }
}
