package software.amazon.awscdk.interfaces.appmesh;

/**
 * A reference to a VirtualRouter resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appmesh.*;
 * VirtualRouterReference virtualRouterReference = VirtualRouterReference.builder()
 *         .virtualRouterArn("virtualRouterArn")
 *         .virtualRouterId("virtualRouterId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appmesh.VirtualRouterReference")
@software.amazon.jsii.Jsii.Proxy(VirtualRouterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualRouterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the VirtualRouter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterArn();

    /**
     * The Id of the VirtualRouter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterId();

    /**
     * @return a {@link Builder} of {@link VirtualRouterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualRouterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualRouterReference> {
        java.lang.String virtualRouterArn;
        java.lang.String virtualRouterId;

        /**
         * Sets the value of {@link VirtualRouterReference#getVirtualRouterArn}
         * @param virtualRouterArn The ARN of the VirtualRouter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterArn(java.lang.String virtualRouterArn) {
            this.virtualRouterArn = virtualRouterArn;
            return this;
        }

        /**
         * Sets the value of {@link VirtualRouterReference#getVirtualRouterId}
         * @param virtualRouterId The Id of the VirtualRouter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterId(java.lang.String virtualRouterId) {
            this.virtualRouterId = virtualRouterId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualRouterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualRouterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualRouterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualRouterReference {
        private final java.lang.String virtualRouterArn;
        private final java.lang.String virtualRouterId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualRouterArn = software.amazon.jsii.Kernel.get(this, "virtualRouterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualRouterId = software.amazon.jsii.Kernel.get(this, "virtualRouterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualRouterArn = java.util.Objects.requireNonNull(builder.virtualRouterArn, "virtualRouterArn is required");
            this.virtualRouterId = java.util.Objects.requireNonNull(builder.virtualRouterId, "virtualRouterId is required");
        }

        @Override
        public final java.lang.String getVirtualRouterArn() {
            return this.virtualRouterArn;
        }

        @Override
        public final java.lang.String getVirtualRouterId() {
            return this.virtualRouterId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualRouterArn", om.valueToTree(this.getVirtualRouterArn()));
            data.set("virtualRouterId", om.valueToTree(this.getVirtualRouterId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appmesh.VirtualRouterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualRouterReference.Jsii$Proxy that = (VirtualRouterReference.Jsii$Proxy) o;

            if (!virtualRouterArn.equals(that.virtualRouterArn)) return false;
            return this.virtualRouterId.equals(that.virtualRouterId);
        }

        @Override
        public final int hashCode() {
            int result = this.virtualRouterArn.hashCode();
            result = 31 * result + (this.virtualRouterId.hashCode());
            return result;
        }
    }
}
