package software.amazon.awscdk.interfaces.apprunner;

/**
 * A reference to a AutoScalingConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.apprunner.*;
 * AutoScalingConfigurationReference autoScalingConfigurationReference = AutoScalingConfigurationReference.builder()
 *         .autoScalingConfigurationArn("autoScalingConfigurationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.077Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_apprunner.AutoScalingConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(AutoScalingConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoScalingConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AutoScalingConfigurationArn of the AutoScalingConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingConfigurationArn();

    /**
     * @return a {@link Builder} of {@link AutoScalingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoScalingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoScalingConfigurationReference> {
        java.lang.String autoScalingConfigurationArn;

        /**
         * Sets the value of {@link AutoScalingConfigurationReference#getAutoScalingConfigurationArn}
         * @param autoScalingConfigurationArn The AutoScalingConfigurationArn of the AutoScalingConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingConfigurationArn(java.lang.String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoScalingConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoScalingConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoScalingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingConfigurationReference {
        private final java.lang.String autoScalingConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingConfigurationArn = software.amazon.jsii.Kernel.get(this, "autoScalingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingConfigurationArn = java.util.Objects.requireNonNull(builder.autoScalingConfigurationArn, "autoScalingConfigurationArn is required");
        }

        @Override
        public final java.lang.String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingConfigurationArn", om.valueToTree(this.getAutoScalingConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_apprunner.AutoScalingConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoScalingConfigurationReference.Jsii$Proxy that = (AutoScalingConfigurationReference.Jsii$Proxy) o;

            return this.autoScalingConfigurationArn.equals(that.autoScalingConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingConfigurationArn.hashCode();
            return result;
        }
    }
}
