package software.amazon.awscdk.interfaces.appsync;

/**
 * A reference to a GraphQLSchema resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.appsync.*;
 * GraphQLSchemaReference graphQLSchemaReference = GraphQLSchemaReference.builder()
 *         .graphQlSchemaId("graphQlSchemaId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_appsync.GraphQLSchemaReference")
@software.amazon.jsii.Jsii.Proxy(GraphQLSchemaReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GraphQLSchemaReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the GraphQLSchema resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGraphQlSchemaId();

    /**
     * @return a {@link Builder} of {@link GraphQLSchemaReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GraphQLSchemaReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GraphQLSchemaReference> {
        java.lang.String graphQlSchemaId;

        /**
         * Sets the value of {@link GraphQLSchemaReference#getGraphQlSchemaId}
         * @param graphQlSchemaId The Id of the GraphQLSchema resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphQlSchemaId(java.lang.String graphQlSchemaId) {
            this.graphQlSchemaId = graphQlSchemaId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GraphQLSchemaReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GraphQLSchemaReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GraphQLSchemaReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GraphQLSchemaReference {
        private final java.lang.String graphQlSchemaId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.graphQlSchemaId = software.amazon.jsii.Kernel.get(this, "graphQlSchemaId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.graphQlSchemaId = java.util.Objects.requireNonNull(builder.graphQlSchemaId, "graphQlSchemaId is required");
        }

        @Override
        public final java.lang.String getGraphQlSchemaId() {
            return this.graphQlSchemaId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("graphQlSchemaId", om.valueToTree(this.getGraphQlSchemaId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_appsync.GraphQLSchemaReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GraphQLSchemaReference.Jsii$Proxy that = (GraphQLSchemaReference.Jsii$Proxy) o;

            return this.graphQlSchemaId.equals(that.graphQlSchemaId);
        }

        @Override
        public final int hashCode() {
            int result = this.graphQlSchemaId.hashCode();
            return result;
        }
    }
}
