package software.amazon.awscdk.interfaces.athena;

/**
 * A reference to a CapacityReservation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.athena.*;
 * CapacityReservationReference capacityReservationReference = CapacityReservationReference.builder()
 *         .capacityReservationArn("capacityReservationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.113Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_athena.CapacityReservationReference")
@software.amazon.jsii.Jsii.Proxy(CapacityReservationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CapacityReservationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the CapacityReservation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCapacityReservationArn();

    /**
     * @return a {@link Builder} of {@link CapacityReservationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CapacityReservationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationReference> {
        java.lang.String capacityReservationArn;

        /**
         * Sets the value of {@link CapacityReservationReference#getCapacityReservationArn}
         * @param capacityReservationArn The Arn of the CapacityReservation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityReservationArn(java.lang.String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CapacityReservationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CapacityReservationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CapacityReservationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationReference {
        private final java.lang.String capacityReservationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacityReservationArn = software.amazon.jsii.Kernel.get(this, "capacityReservationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacityReservationArn = java.util.Objects.requireNonNull(builder.capacityReservationArn, "capacityReservationArn is required");
        }

        @Override
        public final java.lang.String getCapacityReservationArn() {
            return this.capacityReservationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capacityReservationArn", om.valueToTree(this.getCapacityReservationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_athena.CapacityReservationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CapacityReservationReference.Jsii$Proxy that = (CapacityReservationReference.Jsii$Proxy) o;

            return this.capacityReservationArn.equals(that.capacityReservationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.capacityReservationArn.hashCode();
            return result;
        }
    }
}
