package software.amazon.awscdk.interfaces.backupgateway;

/**
 * A reference to a Hypervisor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.backupgateway.*;
 * HypervisorReference hypervisorReference = HypervisorReference.builder()
 *         .hypervisorArn("hypervisorArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.128Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_backupgateway.HypervisorReference")
@software.amazon.jsii.Jsii.Proxy(HypervisorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HypervisorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HypervisorArn of the Hypervisor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHypervisorArn();

    /**
     * @return a {@link Builder} of {@link HypervisorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HypervisorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HypervisorReference> {
        java.lang.String hypervisorArn;

        /**
         * Sets the value of {@link HypervisorReference#getHypervisorArn}
         * @param hypervisorArn The HypervisorArn of the Hypervisor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hypervisorArn(java.lang.String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HypervisorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HypervisorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HypervisorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HypervisorReference {
        private final java.lang.String hypervisorArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hypervisorArn = software.amazon.jsii.Kernel.get(this, "hypervisorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hypervisorArn = java.util.Objects.requireNonNull(builder.hypervisorArn, "hypervisorArn is required");
        }

        @Override
        public final java.lang.String getHypervisorArn() {
            return this.hypervisorArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hypervisorArn", om.valueToTree(this.getHypervisorArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_backupgateway.HypervisorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HypervisorReference.Jsii$Proxy that = (HypervisorReference.Jsii$Proxy) o;

            return this.hypervisorArn.equals(that.hypervisorArn);
        }

        @Override
        public final int hashCode() {
            int result = this.hypervisorArn.hashCode();
            return result;
        }
    }
}
