package software.amazon.awscdk.interfaces.batch;

/**
 * A reference to a ComputeEnvironment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.batch.*;
 * ComputeEnvironmentReference computeEnvironmentReference = ComputeEnvironmentReference.builder()
 *         .computeEnvironmentArn("computeEnvironmentArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_batch.ComputeEnvironmentReference")
@software.amazon.jsii.Jsii.Proxy(ComputeEnvironmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeEnvironmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ComputeEnvironmentArn of the ComputeEnvironment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn();

    /**
     * @return a {@link Builder} of {@link ComputeEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeEnvironmentReference> {
        java.lang.String computeEnvironmentArn;

        /**
         * Sets the value of {@link ComputeEnvironmentReference#getComputeEnvironmentArn}
         * @param computeEnvironmentArn The ComputeEnvironmentArn of the ComputeEnvironment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentArn(java.lang.String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeEnvironmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeEnvironmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeEnvironmentReference {
        private final java.lang.String computeEnvironmentArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironmentArn = software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironmentArn = java.util.Objects.requireNonNull(builder.computeEnvironmentArn, "computeEnvironmentArn is required");
        }

        @Override
        public final java.lang.String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironmentArn", om.valueToTree(this.getComputeEnvironmentArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_batch.ComputeEnvironmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeEnvironmentReference.Jsii$Proxy that = (ComputeEnvironmentReference.Jsii$Proxy) o;

            return this.computeEnvironmentArn.equals(that.computeEnvironmentArn);
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironmentArn.hashCode();
            return result;
        }
    }
}
