package software.amazon.awscdk.interfaces.batch;

/**
 * A reference to a JobDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.batch.*;
 * JobDefinitionReference jobDefinitionReference = JobDefinitionReference.builder()
 *         .jobDefinitionArn("jobDefinitionArn")
 *         .jobDefinitionName("jobDefinitionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.132Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_batch.JobDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(JobDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the JobDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn();

    /**
     * The JobDefinitionName of the JobDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName();

    /**
     * @return a {@link Builder} of {@link JobDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobDefinitionReference> {
        java.lang.String jobDefinitionArn;
        java.lang.String jobDefinitionName;

        /**
         * Sets the value of {@link JobDefinitionReference#getJobDefinitionArn}
         * @param jobDefinitionArn The ARN of the JobDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionArn(java.lang.String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionReference#getJobDefinitionName}
         * @param jobDefinitionName The JobDefinitionName of the JobDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDefinitionReference {
        private final java.lang.String jobDefinitionArn;
        private final java.lang.String jobDefinitionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobDefinitionArn = software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobDefinitionArn = java.util.Objects.requireNonNull(builder.jobDefinitionArn, "jobDefinitionArn is required");
            this.jobDefinitionName = java.util.Objects.requireNonNull(builder.jobDefinitionName, "jobDefinitionName is required");
        }

        @Override
        public final java.lang.String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jobDefinitionArn", om.valueToTree(this.getJobDefinitionArn()));
            data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_batch.JobDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDefinitionReference.Jsii$Proxy that = (JobDefinitionReference.Jsii$Proxy) o;

            if (!jobDefinitionArn.equals(that.jobDefinitionArn)) return false;
            return this.jobDefinitionName.equals(that.jobDefinitionName);
        }

        @Override
        public final int hashCode() {
            int result = this.jobDefinitionArn.hashCode();
            result = 31 * result + (this.jobDefinitionName.hashCode());
            return result;
        }
    }
}
