package software.amazon.awscdk.interfaces.batch;

/**
 * A reference to a JobQueue resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.batch.*;
 * JobQueueReference jobQueueReference = JobQueueReference.builder()
 *         .jobQueueArn("jobQueueArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.143Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_batch.JobQueueReference")
@software.amazon.jsii.Jsii.Proxy(JobQueueReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobQueueReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The JobQueueArn of the JobQueue resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn();

    /**
     * @return a {@link Builder} of {@link JobQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobQueueReference> {
        java.lang.String jobQueueArn;

        /**
         * Sets the value of {@link JobQueueReference#getJobQueueArn}
         * @param jobQueueArn The JobQueueArn of the JobQueue resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueArn(java.lang.String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobQueueReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobQueueReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobQueueReference {
        private final java.lang.String jobQueueArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobQueueArn = software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobQueueArn = java.util.Objects.requireNonNull(builder.jobQueueArn, "jobQueueArn is required");
        }

        @Override
        public final java.lang.String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jobQueueArn", om.valueToTree(this.getJobQueueArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_batch.JobQueueReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobQueueReference.Jsii$Proxy that = (JobQueueReference.Jsii$Proxy) o;

            return this.jobQueueArn.equals(that.jobQueueArn);
        }

        @Override
        public final int hashCode() {
            int result = this.jobQueueArn.hashCode();
            return result;
        }
    }
}
