package software.amazon.awscdk.interfaces.bedrockagentcore;

/**
 * A reference to a Runtime resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.bedrockagentcore.*;
 * RuntimeReference runtimeReference = RuntimeReference.builder()
 *         .agentRuntimeArn("agentRuntimeArn")
 *         .agentRuntimeId("agentRuntimeId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_bedrockagentcore.RuntimeReference")
@software.amazon.jsii.Jsii.Proxy(RuntimeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuntimeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Runtime resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentRuntimeArn();

    /**
     * The AgentRuntimeId of the Runtime resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentRuntimeId();

    /**
     * @return a {@link Builder} of {@link RuntimeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuntimeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuntimeReference> {
        java.lang.String agentRuntimeArn;
        java.lang.String agentRuntimeId;

        /**
         * Sets the value of {@link RuntimeReference#getAgentRuntimeArn}
         * @param agentRuntimeArn The ARN of the Runtime resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeArn(java.lang.String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        /**
         * Sets the value of {@link RuntimeReference#getAgentRuntimeId}
         * @param agentRuntimeId The AgentRuntimeId of the Runtime resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeId(java.lang.String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuntimeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuntimeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuntimeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimeReference {
        private final java.lang.String agentRuntimeArn;
        private final java.lang.String agentRuntimeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentRuntimeArn = software.amazon.jsii.Kernel.get(this, "agentRuntimeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentRuntimeId = software.amazon.jsii.Kernel.get(this, "agentRuntimeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentRuntimeArn = java.util.Objects.requireNonNull(builder.agentRuntimeArn, "agentRuntimeArn is required");
            this.agentRuntimeId = java.util.Objects.requireNonNull(builder.agentRuntimeId, "agentRuntimeId is required");
        }

        @Override
        public final java.lang.String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        @Override
        public final java.lang.String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentRuntimeArn", om.valueToTree(this.getAgentRuntimeArn()));
            data.set("agentRuntimeId", om.valueToTree(this.getAgentRuntimeId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_bedrockagentcore.RuntimeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuntimeReference.Jsii$Proxy that = (RuntimeReference.Jsii$Proxy) o;

            if (!agentRuntimeArn.equals(that.agentRuntimeArn)) return false;
            return this.agentRuntimeId.equals(that.agentRuntimeId);
        }

        @Override
        public final int hashCode() {
            int result = this.agentRuntimeArn.hashCode();
            result = 31 * result + (this.agentRuntimeId.hashCode());
            return result;
        }
    }
}
