package software.amazon.awscdk.interfaces.bedrockagentcore;

/**
 * A reference to a WorkloadIdentity resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.bedrockagentcore.*;
 * WorkloadIdentityReference workloadIdentityReference = WorkloadIdentityReference.builder()
 *         .workloadIdentityArn("workloadIdentityArn")
 *         .workloadIdentityName("workloadIdentityName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_bedrockagentcore.WorkloadIdentityReference")
@software.amazon.jsii.Jsii.Proxy(WorkloadIdentityReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkloadIdentityReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the WorkloadIdentity resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkloadIdentityArn();

    /**
     * The Name of the WorkloadIdentity resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkloadIdentityName();

    /**
     * @return a {@link Builder} of {@link WorkloadIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkloadIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkloadIdentityReference> {
        java.lang.String workloadIdentityArn;
        java.lang.String workloadIdentityName;

        /**
         * Sets the value of {@link WorkloadIdentityReference#getWorkloadIdentityArn}
         * @param workloadIdentityArn The ARN of the WorkloadIdentity resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workloadIdentityArn(java.lang.String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
            return this;
        }

        /**
         * Sets the value of {@link WorkloadIdentityReference#getWorkloadIdentityName}
         * @param workloadIdentityName The Name of the WorkloadIdentity resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workloadIdentityName(java.lang.String workloadIdentityName) {
            this.workloadIdentityName = workloadIdentityName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkloadIdentityReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkloadIdentityReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkloadIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkloadIdentityReference {
        private final java.lang.String workloadIdentityArn;
        private final java.lang.String workloadIdentityName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.workloadIdentityArn = software.amazon.jsii.Kernel.get(this, "workloadIdentityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workloadIdentityName = software.amazon.jsii.Kernel.get(this, "workloadIdentityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.workloadIdentityArn = java.util.Objects.requireNonNull(builder.workloadIdentityArn, "workloadIdentityArn is required");
            this.workloadIdentityName = java.util.Objects.requireNonNull(builder.workloadIdentityName, "workloadIdentityName is required");
        }

        @Override
        public final java.lang.String getWorkloadIdentityArn() {
            return this.workloadIdentityArn;
        }

        @Override
        public final java.lang.String getWorkloadIdentityName() {
            return this.workloadIdentityName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("workloadIdentityArn", om.valueToTree(this.getWorkloadIdentityArn()));
            data.set("workloadIdentityName", om.valueToTree(this.getWorkloadIdentityName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_bedrockagentcore.WorkloadIdentityReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkloadIdentityReference.Jsii$Proxy that = (WorkloadIdentityReference.Jsii$Proxy) o;

            if (!workloadIdentityArn.equals(that.workloadIdentityArn)) return false;
            return this.workloadIdentityName.equals(that.workloadIdentityName);
        }

        @Override
        public final int hashCode() {
            int result = this.workloadIdentityArn.hashCode();
            result = 31 * result + (this.workloadIdentityName.hashCode());
            return result;
        }
    }
}
