package software.amazon.awscdk.interfaces.billing;

/**
 * A reference to a BillingView resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.billing.*;
 * BillingViewReference billingViewReference = BillingViewReference.builder()
 *         .billingViewArn("billingViewArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_billing.BillingViewReference")
@software.amazon.jsii.Jsii.Proxy(BillingViewReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BillingViewReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the BillingView resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBillingViewArn();

    /**
     * @return a {@link Builder} of {@link BillingViewReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BillingViewReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BillingViewReference> {
        java.lang.String billingViewArn;

        /**
         * Sets the value of {@link BillingViewReference#getBillingViewArn}
         * @param billingViewArn The Arn of the BillingView resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingViewArn(java.lang.String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BillingViewReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BillingViewReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BillingViewReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BillingViewReference {
        private final java.lang.String billingViewArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.billingViewArn = software.amazon.jsii.Kernel.get(this, "billingViewArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.billingViewArn = java.util.Objects.requireNonNull(builder.billingViewArn, "billingViewArn is required");
        }

        @Override
        public final java.lang.String getBillingViewArn() {
            return this.billingViewArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("billingViewArn", om.valueToTree(this.getBillingViewArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_billing.BillingViewReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BillingViewReference.Jsii$Proxy that = (BillingViewReference.Jsii$Proxy) o;

            return this.billingViewArn.equals(that.billingViewArn);
        }

        @Override
        public final int hashCode() {
            int result = this.billingViewArn.hashCode();
            return result;
        }
    }
}
