package software.amazon.awscdk.interfaces.billingconductor;

/**
 * A reference to a BillingGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.billingconductor.*;
 * BillingGroupReference billingGroupReference = BillingGroupReference.builder()
 *         .billingGroupArn("billingGroupArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.161Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_billingconductor.BillingGroupReference")
@software.amazon.jsii.Jsii.Proxy(BillingGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BillingGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the BillingGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBillingGroupArn();

    /**
     * @return a {@link Builder} of {@link BillingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BillingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BillingGroupReference> {
        java.lang.String billingGroupArn;

        /**
         * Sets the value of {@link BillingGroupReference#getBillingGroupArn}
         * @param billingGroupArn The Arn of the BillingGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingGroupArn(java.lang.String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BillingGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BillingGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BillingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BillingGroupReference {
        private final java.lang.String billingGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.billingGroupArn = software.amazon.jsii.Kernel.get(this, "billingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.billingGroupArn = java.util.Objects.requireNonNull(builder.billingGroupArn, "billingGroupArn is required");
        }

        @Override
        public final java.lang.String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("billingGroupArn", om.valueToTree(this.getBillingGroupArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_billingconductor.BillingGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BillingGroupReference.Jsii$Proxy that = (BillingGroupReference.Jsii$Proxy) o;

            return this.billingGroupArn.equals(that.billingGroupArn);
        }

        @Override
        public final int hashCode() {
            int result = this.billingGroupArn.hashCode();
            return result;
        }
    }
}
