package software.amazon.awscdk.interfaces.billingconductor;

/**
 * A reference to a CustomLineItem resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.billingconductor.*;
 * CustomLineItemReference customLineItemReference = CustomLineItemReference.builder()
 *         .customLineItemArn("customLineItemArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.161Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_billingconductor.CustomLineItemReference")
@software.amazon.jsii.Jsii.Proxy(CustomLineItemReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomLineItemReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the CustomLineItem resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomLineItemArn();

    /**
     * @return a {@link Builder} of {@link CustomLineItemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomLineItemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomLineItemReference> {
        java.lang.String customLineItemArn;

        /**
         * Sets the value of {@link CustomLineItemReference#getCustomLineItemArn}
         * @param customLineItemArn The Arn of the CustomLineItem resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemArn(java.lang.String customLineItemArn) {
            this.customLineItemArn = customLineItemArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomLineItemReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomLineItemReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomLineItemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomLineItemReference {
        private final java.lang.String customLineItemArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customLineItemArn = software.amazon.jsii.Kernel.get(this, "customLineItemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customLineItemArn = java.util.Objects.requireNonNull(builder.customLineItemArn, "customLineItemArn is required");
        }

        @Override
        public final java.lang.String getCustomLineItemArn() {
            return this.customLineItemArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customLineItemArn", om.valueToTree(this.getCustomLineItemArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_billingconductor.CustomLineItemReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomLineItemReference.Jsii$Proxy that = (CustomLineItemReference.Jsii$Proxy) o;

            return this.customLineItemArn.equals(that.customLineItemArn);
        }

        @Override
        public final int hashCode() {
            int result = this.customLineItemArn.hashCode();
            return result;
        }
    }
}
